/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.cluster;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.LocalNodeMasterListener;
import org.elasticsearch.cluster.TimeoutClusterStateListener;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.OperationRouting;
import org.elasticsearch.cluster.routing.allocation.decider.AwarenessAllocationDecider;
import org.elasticsearch.cluster.service.PendingClusterTask;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.component.Lifecycle;
import org.elasticsearch.common.component.LifecycleListener;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.DummyTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.FutureUtils;
import org.elasticsearch.tasks.TaskManager;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TestClusterService
implements ClusterService {
    volatile ClusterState state;
    private volatile TaskManager taskManager;
    private final List<ClusterStateListener> listeners = new CopyOnWriteArrayList<ClusterStateListener>();
    private final Queue<NotifyTimeout> onGoingTimeouts = ConcurrentCollections.newQueue();
    private final ThreadPool threadPool;
    private final ESLogger logger = Loggers.getLogger(this.getClass(), (Settings)Settings.EMPTY, (String[])new String[0]);
    private final OperationRouting operationRouting = new OperationRouting(Settings.Builder.EMPTY_SETTINGS, new AwarenessAllocationDecider());

    public TestClusterService() {
        this(ClusterState.builder((ClusterName)new ClusterName("test")).build());
    }

    public TestClusterService(ThreadPool threadPool) {
        this(ClusterState.builder((ClusterName)new ClusterName("test")).build(), threadPool);
        this.taskManager = new TaskManager(Settings.EMPTY);
    }

    public TestClusterService(ThreadPool threadPool, TransportService transportService) {
        this(ClusterState.builder((ClusterName)new ClusterName("test")).build(), threadPool);
        this.taskManager = transportService.getTaskManager();
    }

    public TestClusterService(ClusterState state) {
        this(state, null);
    }

    public TestClusterService(ClusterState state, @Nullable ThreadPool threadPool) {
        if (state.getNodes().size() == 0) {
            state = ClusterState.builder((ClusterState)state).nodes(DiscoveryNodes.builder().put(new DiscoveryNode("test_node", (TransportAddress)DummyTransportAddress.INSTANCE, Version.CURRENT)).localNodeId("test_node")).build();
        }
        assert (state.getNodes().localNode() != null);
        this.state = state;
        this.threadPool = threadPool;
    }

    public synchronized ClusterState setState(ClusterState state) {
        assert (state.getNodes().localNode() != null);
        state = ClusterState.builder((ClusterState)state).version(this.state.version() + 1L).build();
        return this.setStateAndNotifyListeners(state);
    }

    private ClusterState setStateAndNotifyListeners(ClusterState state) {
        ClusterChangedEvent event = new ClusterChangedEvent("test", state, this.state);
        this.state = state;
        for (ClusterStateListener listener : this.listeners) {
            listener.clusterChanged(event);
        }
        return state;
    }

    public ClusterState setState(ClusterState.Builder state) {
        return this.setState(state.build());
    }

    public DiscoveryNode localNode() {
        return this.state.getNodes().localNode();
    }

    public ClusterState state() {
        return this.state;
    }

    public void addInitialStateBlock(ClusterBlock block) throws IllegalStateException {
        throw new UnsupportedOperationException();
    }

    public void removeInitialStateBlock(ClusterBlock block) throws IllegalStateException {
        throw new UnsupportedOperationException();
    }

    public OperationRouting operationRouting() {
        return this.operationRouting;
    }

    public void addFirst(ClusterStateListener listener) {
        this.listeners.add(0, listener);
    }

    public void addLast(ClusterStateListener listener) {
        this.listeners.add(listener);
    }

    public void add(ClusterStateListener listener) {
        this.listeners.add(listener);
    }

    public void remove(ClusterStateListener listener) {
        this.listeners.remove(listener);
        Iterator it = this.onGoingTimeouts.iterator();
        while (it.hasNext()) {
            NotifyTimeout timeout = (NotifyTimeout)it.next();
            if (!timeout.listener.equals(listener)) continue;
            timeout.cancel();
            it.remove();
        }
    }

    public void add(LocalNodeMasterListener listener) {
        throw new UnsupportedOperationException();
    }

    public void remove(LocalNodeMasterListener listener) {
        throw new UnsupportedOperationException();
    }

    public void add(TimeValue timeout, TimeoutClusterStateListener listener) {
        if (this.threadPool == null) {
            throw new UnsupportedOperationException("TestClusterService wasn't initialized with a thread pool");
        }
        NotifyTimeout notifyTimeout = new NotifyTimeout(listener, timeout);
        notifyTimeout.future = this.threadPool.schedule(timeout, "generic", (Runnable)notifyTimeout);
        this.onGoingTimeouts.add(notifyTimeout);
        this.listeners.add((ClusterStateListener)listener);
        listener.postAdded();
    }

    public void submitStateUpdateTask(String source, ClusterStateUpdateTask updateTask) {
        this.submitStateUpdateTask(source, null, (ClusterStateTaskConfig)updateTask, (ClusterStateTaskExecutor)updateTask, (ClusterStateTaskListener)updateTask);
    }

    public synchronized <T> void submitStateUpdateTask(final String source, T task, ClusterStateTaskConfig config, ClusterStateTaskExecutor<T> executor, final ClusterStateTaskListener listener) {
        ClusterStateTaskExecutor.BatchResult batchResult;
        this.logger.debug("processing [{}]", new Object[]{source});
        if (!this.state().nodes().localNodeMaster() && executor.runOnlyOnMaster()) {
            listener.onNoLongerMaster(source);
            this.logger.debug("failed [{}], no longer master", new Object[]{source});
            return;
        }
        ClusterState previousClusterState = this.state;
        try {
            batchResult = executor.execute(previousClusterState, Arrays.asList(task));
        }
        catch (Exception e) {
            batchResult = ClusterStateTaskExecutor.BatchResult.builder().failure(task, (Throwable)e).build(previousClusterState);
        }
        ((ClusterStateTaskExecutor.TaskResult)batchResult.executionResults.get(task)).handle(new Runnable(){

            @Override
            public void run() {
            }
        }, new ClusterStateTaskExecutor.TaskResult.FailureConsumer(){

            public void accept(Throwable ex) {
                listener.onFailure(source, (Throwable)new ElasticsearchException("failed to process cluster state update task [" + source + "]", ex, new Object[0]));
            }
        });
        this.setStateAndNotifyListeners(batchResult.resultingState);
        listener.clusterStateProcessed(source, previousClusterState, batchResult.resultingState);
        this.logger.debug("finished [{}]", new Object[]{source});
    }

    public TimeValue getMaxTaskWaitTime() {
        throw new UnsupportedOperationException();
    }

    public TaskManager getTaskManager() {
        return this.taskManager;
    }

    public List<PendingClusterTask> pendingTasks() {
        throw new UnsupportedOperationException();
    }

    public int numberOfPendingTasks() {
        throw new UnsupportedOperationException();
    }

    public Lifecycle.State lifecycleState() {
        throw new UnsupportedOperationException();
    }

    public void addLifecycleListener(LifecycleListener listener) {
        throw new UnsupportedOperationException();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        throw new UnsupportedOperationException();
    }

    public ClusterService start() throws ElasticsearchException {
        throw new UnsupportedOperationException();
    }

    public ClusterService stop() throws ElasticsearchException {
        throw new UnsupportedOperationException();
    }

    public void close() throws ElasticsearchException {
        throw new UnsupportedOperationException();
    }

    class NotifyTimeout
    implements Runnable {
        final TimeoutClusterStateListener listener;
        final TimeValue timeout;
        volatile ScheduledFuture future;

        NotifyTimeout(TimeoutClusterStateListener listener, TimeValue timeout) {
            this.listener = listener;
            this.timeout = timeout;
        }

        public void cancel() {
            FutureUtils.cancel((Future)this.future);
        }

        @Override
        public void run() {
            if (this.future != null && this.future.isCancelled()) {
                return;
            }
            this.listener.onTimeout(this.timeout);
        }
    }
}

