/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.discovery;

import com.carrotsearch.randomizedtesting.RandomizedTest;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.HashSet;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.network.NetworkUtils;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.test.InternalTestCluster;
import org.elasticsearch.test.NodeConfigurationSource;

public class ClusterDiscoveryConfiguration
extends NodeConfigurationSource {
    static Settings DEFAULT_NODE_SETTINGS = Settings.settingsBuilder().put("discovery.type", "zen").build();
    private static final String IP_ADDR = "127.0.0.1";
    final int numOfNodes;
    final Settings nodeSettings;
    final Settings transportClientSettings;

    public ClusterDiscoveryConfiguration(int numOfNodes, Settings extraSettings) {
        this.numOfNodes = numOfNodes;
        this.nodeSettings = Settings.builder().put(DEFAULT_NODE_SETTINGS).put(extraSettings).build();
        this.transportClientSettings = Settings.builder().put(extraSettings).build();
    }

    @Override
    public Settings nodeSettings(int nodeOrdinal) {
        return this.nodeSettings;
    }

    @Override
    public Settings transportClientSettings() {
        return this.transportClientSettings;
    }

    public static class UnicastZen
    extends ClusterDiscoveryConfiguration {
        private static int nextPort = UnicastZen.calcBasePort();
        private final int[] unicastHostOrdinals;
        private final int[] unicastHostPorts;

        public UnicastZen(int numOfNodes, Settings extraSettings) {
            this(numOfNodes, numOfNodes, extraSettings);
        }

        public UnicastZen(int numOfNodes, int numOfUnicastHosts, Settings extraSettings) {
            super(numOfNodes, extraSettings);
            if (numOfUnicastHosts == numOfNodes) {
                this.unicastHostOrdinals = new int[numOfNodes];
                for (int i = 0; i < numOfNodes; ++i) {
                    this.unicastHostOrdinals[i] = i;
                }
            } else {
                HashSet<Integer> ordinals = new HashSet<Integer>(numOfUnicastHosts);
                while (ordinals.size() != numOfUnicastHosts) {
                    ordinals.add(RandomizedTest.randomInt((int)(numOfNodes - 1)));
                }
                this.unicastHostOrdinals = Ints.toArray(ordinals);
            }
            this.unicastHostPorts = UnicastZen.unicastHostPorts(numOfNodes);
            assert (this.unicastHostOrdinals.length <= this.unicastHostPorts.length);
        }

        public UnicastZen(int numOfNodes, int[] unicastHostOrdinals) {
            this(numOfNodes, Settings.EMPTY, unicastHostOrdinals);
        }

        public UnicastZen(int numOfNodes, Settings extraSettings, int[] unicastHostOrdinals) {
            super(numOfNodes, extraSettings);
            this.unicastHostOrdinals = unicastHostOrdinals;
            this.unicastHostPorts = UnicastZen.unicastHostPorts(numOfNodes);
            assert (unicastHostOrdinals.length <= this.unicastHostPorts.length);
        }

        private static int calcBasePort() {
            return 30000 + InternalTestCluster.JVM_BASE_PORT_OFFEST;
        }

        @Override
        public Settings nodeSettings(int nodeOrdinal) {
            Settings.Builder builder = Settings.builder();
            String[] unicastHosts = new String[this.unicastHostOrdinals.length];
            if (nodeOrdinal >= this.unicastHostPorts.length) {
                throw new ElasticsearchException("nodeOrdinal [" + nodeOrdinal + "] is greater than the number unicast ports [" + this.unicastHostPorts.length + "]", new Object[0]);
            }
            builder.put("transport.tcp.port", this.unicastHostPorts[nodeOrdinal]);
            builder.put("transport.host", ClusterDiscoveryConfiguration.IP_ADDR);
            builder.put("transport.bind_host", ClusterDiscoveryConfiguration.IP_ADDR);
            builder.put("transport.publish_host", ClusterDiscoveryConfiguration.IP_ADDR);
            builder.put("http.enabled", false);
            for (int i = 0; i < this.unicastHostOrdinals.length; ++i) {
                unicastHosts[i] = "127.0.0.1:" + this.unicastHostPorts[this.unicastHostOrdinals[i]];
            }
            builder.putArray("discovery.zen.ping.unicast.hosts", unicastHosts);
            return builder.put(super.nodeSettings(nodeOrdinal)).build();
        }

        @SuppressForbidden(reason="we know we pass a IP address")
        protected static synchronized int[] unicastHostPorts(int numHosts) {
            int[] unicastHostPorts = new int[numHosts];
            int basePort = UnicastZen.calcBasePort();
            int maxPort = basePort + 100;
            int tries = 0;
            for (int i = 0; i < unicastHostPorts.length; ++i) {
                boolean foundPortInRange = false;
                while (tries < 100 && !foundPortInRange) {
                    try (ServerSocket serverSocket = new ServerSocket();){
                        serverSocket.setReuseAddress(NetworkUtils.defaultReuseAddress());
                        serverSocket.bind(new InetSocketAddress(ClusterDiscoveryConfiguration.IP_ADDR, nextPort));
                        foundPortInRange = true;
                        unicastHostPorts[i] = nextPort;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (++nextPort >= maxPort) {
                        nextPort = basePort;
                    }
                    ++tries;
                }
                if (foundPortInRange) continue;
                throw new ElasticsearchException("could not find enough open ports in range [" + basePort + "-" + maxPort + "]. required [" + unicastHostPorts.length + "] ports", new Object[0]);
            }
            return unicastHostPorts;
        }
    }
}

