/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.disruption;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.regex.Pattern;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.test.InternalTestCluster;
import org.elasticsearch.test.disruption.SingleNodeDisruption;

public class LongGCDisruption
extends SingleNodeDisruption {
    private static final Pattern[] unsafeClasses = new Pattern[]{Pattern.compile("Logger")};
    protected final String disruptedNode;
    private Set<Thread> suspendedThreads;

    public LongGCDisruption(Random random, String disruptedNode) {
        super(random);
        this.disruptedNode = disruptedNode;
    }

    @Override
    public synchronized void startDisrupting() {
        if (this.suspendedThreads != null) {
            throw new IllegalStateException("can't disrupt twice, call stopDisrupting() first");
        }
        this.suspendedThreads = new HashSet<Thread>();
        this.stopNodeThreads(this.disruptedNode, this.suspendedThreads);
    }

    @Override
    public synchronized void stopDisrupting() {
        if (this.suspendedThreads != null) {
            this.resumeThreads(this.suspendedThreads);
            this.suspendedThreads = null;
        }
    }

    @Override
    public void removeAndEnsureHealthy(InternalTestCluster cluster) {
        this.removeFromCluster(cluster);
        this.ensureNodeCount(cluster);
    }

    @Override
    public TimeValue expectedTimeToHeal() {
        return TimeValue.timeValueMillis((long)0L);
    }

    @SuppressForbidden(reason="stops/resumes threads intentionally")
    protected boolean stopNodeThreads(String node, Set<Thread> nodeThreads) {
        Thread[] allThreads = null;
        while (allThreads == null) {
            allThreads = new Thread[Thread.activeCount()];
            if (Thread.enumerate(allThreads) <= allThreads.length) continue;
            allThreads = null;
        }
        boolean stopped = false;
        String nodeThreadNamePart = "[" + node + "]";
        for (Thread thread : allThreads) {
            String name;
            if (thread == null || !(name = thread.getName()).contains(nodeThreadNamePart) || !thread.isAlive() || !nodeThreads.add(thread)) continue;
            stopped = true;
            thread.suspend();
            boolean safe = true;
            block2: for (StackTraceElement stackElement : thread.getStackTrace()) {
                String className = stackElement.getClassName();
                for (Pattern unsafePattern : unsafeClasses) {
                    if (!unsafePattern.matcher(className).find()) continue;
                    safe = false;
                    break block2;
                }
            }
            if (safe) continue;
            thread.resume();
            nodeThreads.remove(thread);
        }
        return stopped;
    }

    @SuppressForbidden(reason="stops/resumes threads intentionally")
    protected void resumeThreads(Set<Thread> threads) {
        for (Thread thread : threads) {
            thread.resume();
        }
    }
}

