/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.disruption;

import java.util.Random;
import java.util.Set;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.test.disruption.NetworkPartition;
import org.elasticsearch.test.transport.MockTransportService;

public class NetworkDelaysPartition
extends NetworkPartition {
    static long DEFAULT_DELAY_MIN = 10000L;
    static long DEFAULT_DELAY_MAX = 90000L;
    final long delayMin;
    final long delayMax;
    TimeValue duration;

    public NetworkDelaysPartition(Random random) {
        this(random, DEFAULT_DELAY_MIN, DEFAULT_DELAY_MAX);
    }

    public NetworkDelaysPartition(Random random, long delayMin, long delayMax) {
        super(random);
        this.delayMin = delayMin;
        this.delayMax = delayMax;
    }

    public NetworkDelaysPartition(String node1, String node2, Random random) {
        this(node1, node2, DEFAULT_DELAY_MIN, DEFAULT_DELAY_MAX, random);
    }

    public NetworkDelaysPartition(String node1, String node2, long delayMin, long delayMax, Random random) {
        super(node1, node2, random);
        this.delayMin = delayMin;
        this.delayMax = delayMax;
    }

    public NetworkDelaysPartition(Set<String> nodesSideOne, Set<String> nodesSideTwo, Random random) {
        this(nodesSideOne, nodesSideTwo, DEFAULT_DELAY_MIN, DEFAULT_DELAY_MAX, random);
    }

    public NetworkDelaysPartition(Set<String> nodesSideOne, Set<String> nodesSideTwo, long delayMin, long delayMax, Random random) {
        super(nodesSideOne, nodesSideTwo, random);
        this.delayMin = delayMin;
        this.delayMax = delayMax;
    }

    @Override
    public synchronized void startDisrupting() {
        this.duration = new TimeValue(this.delayMin + (long)this.random.nextInt((int)(this.delayMax - this.delayMin)));
        super.startDisrupting();
    }

    @Override
    void applyDisruption(MockTransportService transportService1, MockTransportService transportService2) {
        transportService1.addUnresponsiveRule(transportService1, this.duration);
        transportService1.addUnresponsiveRule(transportService2, this.duration);
    }

    @Override
    protected String getPartitionDescription() {
        return "network delays for [" + this.duration + "]";
    }

    @Override
    public TimeValue expectedTimeToHeal() {
        return TimeValue.timeValueMillis((long)this.delayMax);
    }
}

