/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.disruption;

import java.util.Random;
import java.util.Set;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.test.disruption.NetworkPartition;
import org.elasticsearch.test.transport.MockTransportService;

public class NetworkDisconnectPartition
extends NetworkPartition {
    public NetworkDisconnectPartition(Random random) {
        super(random);
    }

    public NetworkDisconnectPartition(String node1, String node2, Random random) {
        super(node1, node2, random);
    }

    public NetworkDisconnectPartition(Set<String> nodesSideOne, Set<String> nodesSideTwo, Random random) {
        super(nodesSideOne, nodesSideTwo, random);
    }

    @Override
    protected String getPartitionDescription() {
        return "disconnected";
    }

    @Override
    void applyDisruption(MockTransportService transportService1, MockTransportService transportService2) {
        transportService1.addFailToSendNoConnectRule(transportService2);
        transportService2.addFailToSendNoConnectRule(transportService1);
    }

    @Override
    public TimeValue expectedTimeToHeal() {
        return TimeValue.timeValueSeconds((long)0L);
    }
}

