/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.disruption;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.test.InternalTestCluster;
import org.elasticsearch.test.disruption.ServiceDisruptionScheme;
import org.elasticsearch.test.transport.MockTransportService;
import org.elasticsearch.transport.TransportService;
import org.junit.Assert;

public abstract class NetworkPartition
implements ServiceDisruptionScheme {
    protected final ESLogger logger = Loggers.getLogger(this.getClass());
    final Set<String> nodesSideOne;
    final Set<String> nodesSideTwo;
    volatile boolean autoExpand;
    protected final Random random;
    protected volatile InternalTestCluster cluster;
    protected volatile boolean activeDisruption = false;

    public NetworkPartition(Random random) {
        this.random = new Random(random.nextLong());
        this.nodesSideOne = new HashSet<String>();
        this.nodesSideTwo = new HashSet<String>();
        this.autoExpand = true;
    }

    public NetworkPartition(String node1, String node2, Random random) {
        this(random);
        this.nodesSideOne.add(node1);
        this.nodesSideTwo.add(node2);
        this.autoExpand = false;
    }

    public NetworkPartition(Set<String> nodesSideOne, Set<String> nodesSideTwo, Random random) {
        this(random);
        this.nodesSideOne.addAll(nodesSideOne);
        this.nodesSideTwo.addAll(nodesSideTwo);
        this.autoExpand = false;
    }

    public Collection<String> getNodesSideOne() {
        return Collections.unmodifiableCollection(this.nodesSideOne);
    }

    public Collection<String> getNodesSideTwo() {
        return Collections.unmodifiableCollection(this.nodesSideTwo);
    }

    public Collection<String> getMajoritySide() {
        if (this.nodesSideOne.size() >= this.nodesSideTwo.size()) {
            return this.getNodesSideOne();
        }
        return this.getNodesSideTwo();
    }

    public Collection<String> getMinoritySide() {
        if (this.nodesSideOne.size() >= this.nodesSideTwo.size()) {
            return this.getNodesSideTwo();
        }
        return this.getNodesSideOne();
    }

    @Override
    public void applyToCluster(InternalTestCluster cluster) {
        this.cluster = cluster;
        if (this.autoExpand) {
            for (String node : cluster.getNodeNames()) {
                this.applyToNode(node, cluster);
            }
        }
    }

    @Override
    public void removeFromCluster(InternalTestCluster cluster) {
        this.stopDisrupting();
    }

    @Override
    public void removeAndEnsureHealthy(InternalTestCluster cluster) {
        this.removeFromCluster(cluster);
        this.ensureNodeCount(cluster);
    }

    protected void ensureNodeCount(InternalTestCluster cluster) {
        Assert.assertFalse((String)"cluster failed to form after disruption was healed", (boolean)((ClusterHealthResponse)cluster.client().admin().cluster().prepareHealth(new String[0]).setWaitForNodes("" + cluster.size()).setWaitForRelocatingShards(0).get()).isTimedOut());
    }

    @Override
    public synchronized void applyToNode(String node, InternalTestCluster cluster) {
        if (!this.autoExpand || this.nodesSideOne.contains(node) || this.nodesSideTwo.contains(node)) {
            return;
        }
        if (this.nodesSideOne.isEmpty()) {
            this.nodesSideOne.add(node);
        } else if (this.nodesSideTwo.isEmpty()) {
            this.nodesSideTwo.add(node);
        } else if (this.random.nextBoolean()) {
            this.nodesSideOne.add(node);
        } else {
            this.nodesSideTwo.add(node);
        }
    }

    @Override
    public synchronized void removeFromNode(String node, InternalTestCluster cluster) {
        Set<String> otherSideNodes;
        MockTransportService transportService = (MockTransportService)cluster.getInstance(TransportService.class, node);
        if (this.nodesSideOne.contains(node)) {
            otherSideNodes = this.nodesSideTwo;
            this.nodesSideOne.remove(node);
        } else if (this.nodesSideTwo.contains(node)) {
            otherSideNodes = this.nodesSideOne;
            this.nodesSideTwo.remove(node);
        } else {
            return;
        }
        for (String node2 : otherSideNodes) {
            MockTransportService transportService2 = (MockTransportService)cluster.getInstance(TransportService.class, node2);
            this.removeDisruption(transportService, transportService2);
        }
    }

    @Override
    public synchronized void testClusterClosed() {
    }

    protected abstract String getPartitionDescription();

    @Override
    public synchronized void startDisrupting() {
        if (this.nodesSideOne.size() == 0 || this.nodesSideTwo.size() == 0) {
            return;
        }
        this.logger.info("nodes {} will be partitioned from {}. partition type [{}]", new Object[]{this.nodesSideOne, this.nodesSideTwo, this.getPartitionDescription()});
        this.activeDisruption = true;
        for (String node1 : this.nodesSideOne) {
            MockTransportService transportService1 = (MockTransportService)this.cluster.getInstance(TransportService.class, node1);
            for (String node2 : this.nodesSideTwo) {
                MockTransportService transportService2 = (MockTransportService)this.cluster.getInstance(TransportService.class, node2);
                this.applyDisruption(transportService1, transportService2);
            }
        }
    }

    @Override
    public synchronized void stopDisrupting() {
        if (this.nodesSideOne.size() == 0 || this.nodesSideTwo.size() == 0 || !this.activeDisruption) {
            return;
        }
        this.logger.info("restoring partition between nodes {} & nodes {}", new Object[]{this.nodesSideOne, this.nodesSideTwo});
        for (String node1 : this.nodesSideOne) {
            MockTransportService transportService1 = (MockTransportService)this.cluster.getInstance(TransportService.class, node1);
            for (String node2 : this.nodesSideTwo) {
                MockTransportService transportService2 = (MockTransportService)this.cluster.getInstance(TransportService.class, node2);
                this.removeDisruption(transportService1, transportService2);
            }
        }
        this.activeDisruption = false;
    }

    abstract void applyDisruption(MockTransportService var1, MockTransportService var2);

    protected void removeDisruption(MockTransportService transportService1, MockTransportService transportService2) {
        transportService1.clearRule(transportService2);
        transportService2.clearRule(transportService1);
    }
}

