/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.disruption;

import java.io.IOException;
import java.util.Collection;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.test.ESIntegTestCase;
import org.elasticsearch.test.InternalTestCluster;
import org.elasticsearch.test.disruption.NetworkUnresponsivePartition;
import org.elasticsearch.test.transport.MockTransportService;
import org.junit.Test;

public class NetworkPartitionIT
extends ESIntegTestCase {
    @Override
    protected Collection<Class<? extends Plugin>> nodePlugins() {
        return NetworkPartitionIT.pluginList(MockTransportService.TestPlugin.class);
    }

    @Test
    public void testNetworkPartitionWithNodeShutdown() throws IOException {
        NetworkPartitionIT.internalCluster().ensureAtLeastNumDataNodes(2);
        String[] nodeNames = NetworkPartitionIT.internalCluster().getNodeNames();
        NetworkUnresponsivePartition networkPartition = new NetworkUnresponsivePartition(nodeNames[0], nodeNames[1], NetworkPartitionIT.getRandom());
        NetworkPartitionIT.internalCluster().setDisruptionScheme(networkPartition);
        networkPartition.startDisrupting();
        NetworkPartitionIT.internalCluster().stopRandomNode(InternalTestCluster.nameFilter(nodeNames[0]));
        NetworkPartitionIT.internalCluster().clearDisruptionScheme();
    }
}

