/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.disruption;

import java.util.Random;
import java.util.Set;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.test.disruption.NetworkPartition;
import org.elasticsearch.test.transport.MockTransportService;

public class NetworkUnresponsivePartition
extends NetworkPartition {
    public NetworkUnresponsivePartition(Random random) {
        super(random);
    }

    public NetworkUnresponsivePartition(String node1, String node2, Random random) {
        super(node1, node2, random);
    }

    public NetworkUnresponsivePartition(Set<String> nodesSideOne, Set<String> nodesSideTwo, Random random) {
        super(nodesSideOne, nodesSideTwo, random);
    }

    @Override
    protected String getPartitionDescription() {
        return "unresponsive";
    }

    @Override
    void applyDisruption(MockTransportService transportService1, MockTransportService transportService2) {
        transportService1.addUnresponsiveRule(transportService2);
        transportService2.addUnresponsiveRule(transportService1);
    }

    @Override
    public TimeValue expectedTimeToHeal() {
        return TimeValue.timeValueSeconds((long)0L);
    }
}

