/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.disruption;

import java.util.Random;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.test.InternalTestCluster;
import org.elasticsearch.test.disruption.ServiceDisruptionScheme;
import org.junit.Assert;

public abstract class SingleNodeDisruption
implements ServiceDisruptionScheme {
    protected final ESLogger logger = Loggers.getLogger(this.getClass());
    protected volatile String disruptedNode;
    protected volatile InternalTestCluster cluster;
    protected final Random random;

    public SingleNodeDisruption(String disruptedNode, Random random) {
        this(random);
        this.disruptedNode = disruptedNode;
    }

    public SingleNodeDisruption(Random random) {
        this.random = new Random(random.nextLong());
    }

    @Override
    public void applyToCluster(InternalTestCluster cluster) {
        this.cluster = cluster;
        if (this.disruptedNode == null) {
            String[] nodes = cluster.getNodeNames();
            this.disruptedNode = nodes[this.random.nextInt(nodes.length)];
        }
    }

    @Override
    public void removeFromCluster(InternalTestCluster cluster) {
        if (this.disruptedNode != null) {
            this.removeFromNode(this.disruptedNode, cluster);
        }
    }

    @Override
    public synchronized void applyToNode(String node, InternalTestCluster cluster) {
    }

    @Override
    public synchronized void removeFromNode(String node, InternalTestCluster cluster) {
        if (this.disruptedNode == null) {
            return;
        }
        if (!node.equals(this.disruptedNode)) {
            return;
        }
        this.stopDisrupting();
        this.disruptedNode = null;
    }

    @Override
    public synchronized void testClusterClosed() {
        this.disruptedNode = null;
    }

    protected void ensureNodeCount(InternalTestCluster cluster) {
        Assert.assertFalse((String)"cluster failed to form after disruption was healed", (boolean)((ClusterHealthResponse)cluster.client().admin().cluster().prepareHealth(new String[0]).setWaitForNodes("" + cluster.size()).setWaitForRelocatingShards(0).get()).isTimedOut());
    }
}

