/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.disruption;

import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.test.InternalTestCluster;
import org.elasticsearch.test.disruption.SingleNodeDisruption;

public class SlowClusterStateProcessing
extends SingleNodeDisruption {
    volatile boolean disrupting;
    volatile Thread worker;
    final long intervalBetweenDelaysMin;
    final long intervalBetweenDelaysMax;
    final long delayDurationMin;
    final long delayDurationMax;

    public SlowClusterStateProcessing(Random random) {
        this(null, random);
    }

    public SlowClusterStateProcessing(String disruptedNode, Random random) {
        this(disruptedNode, random, 100L, 200L, 300L, 20000L);
    }

    public SlowClusterStateProcessing(String disruptedNode, Random random, long intervalBetweenDelaysMin, long intervalBetweenDelaysMax, long delayDurationMin, long delayDurationMax) {
        this(random, intervalBetweenDelaysMin, intervalBetweenDelaysMax, delayDurationMin, delayDurationMax);
        this.disruptedNode = disruptedNode;
    }

    public SlowClusterStateProcessing(Random random, long intervalBetweenDelaysMin, long intervalBetweenDelaysMax, long delayDurationMin, long delayDurationMax) {
        super(random);
        this.intervalBetweenDelaysMin = intervalBetweenDelaysMin;
        this.intervalBetweenDelaysMax = intervalBetweenDelaysMax;
        this.delayDurationMin = delayDurationMin;
        this.delayDurationMax = delayDurationMax;
    }

    @Override
    public void startDisrupting() {
        this.disrupting = true;
        this.worker = new Thread(new BackgroundWorker());
        this.worker.setDaemon(true);
        this.worker.start();
    }

    @Override
    public void stopDisrupting() {
        if (this.worker == null) {
            return;
        }
        this.logger.info("stopping to slow down cluster state processing on [{}]", new Object[]{this.disruptedNode});
        this.disrupting = false;
        this.worker.interrupt();
        try {
            this.worker.join(2L * (this.intervalBetweenDelaysMax + this.delayDurationMax));
        }
        catch (InterruptedException e) {
            this.logger.info("background thread failed to stop", new Object[0]);
        }
        this.worker = null;
    }

    private boolean interruptClusterStateProcessing(final TimeValue duration) throws InterruptedException {
        String disruptionNodeCopy = this.disruptedNode;
        if (disruptionNodeCopy == null) {
            return false;
        }
        this.logger.info("delaying cluster state updates on node [{}] for [{}]", new Object[]{disruptionNodeCopy, duration});
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        ClusterService clusterService = this.cluster.getInstance(ClusterService.class, disruptionNodeCopy);
        if (clusterService == null) {
            return false;
        }
        final AtomicBoolean stopped = new AtomicBoolean(false);
        clusterService.submitStateUpdateTask("service_disruption_delay", new ClusterStateUpdateTask(Priority.IMMEDIATE){

            public boolean runOnlyOnMaster() {
                return false;
            }

            public ClusterState execute(ClusterState currentState) throws Exception {
                for (long count = duration.millis() / 200L; count > 0L && !stopped.get(); --count) {
                    Thread.sleep(200L);
                }
                if (!stopped.get()) {
                    Thread.sleep(duration.millis() % 200L);
                }
                countDownLatch.countDown();
                return currentState;
            }

            public void onFailure(String source, Throwable t) {
                countDownLatch.countDown();
            }
        });
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            stopped.set(true);
            countDownLatch.await();
        }
        return true;
    }

    @Override
    public void removeAndEnsureHealthy(InternalTestCluster cluster) {
        this.removeFromCluster(cluster);
        this.ensureNodeCount(cluster);
    }

    @Override
    public TimeValue expectedTimeToHeal() {
        return TimeValue.timeValueMillis((long)0L);
    }

    class BackgroundWorker
    implements Runnable {
        BackgroundWorker() {
        }

        @Override
        public void run() {
            while (SlowClusterStateProcessing.this.disrupting && SlowClusterStateProcessing.this.disruptedNode != null) {
                try {
                    TimeValue duration = new TimeValue(SlowClusterStateProcessing.this.delayDurationMin + (long)SlowClusterStateProcessing.this.random.nextInt((int)(SlowClusterStateProcessing.this.delayDurationMax - SlowClusterStateProcessing.this.delayDurationMin)));
                    if (!SlowClusterStateProcessing.this.interruptClusterStateProcessing(duration) || SlowClusterStateProcessing.this.intervalBetweenDelaysMax <= 0L) continue;
                    duration = new TimeValue(SlowClusterStateProcessing.this.intervalBetweenDelaysMin + (long)SlowClusterStateProcessing.this.random.nextInt((int)(SlowClusterStateProcessing.this.intervalBetweenDelaysMax - SlowClusterStateProcessing.this.intervalBetweenDelaysMin)));
                    if (!SlowClusterStateProcessing.this.disrupting || SlowClusterStateProcessing.this.disruptedNode == null) continue;
                    Thread.sleep(duration.millis());
                }
                catch (InterruptedException duration) {
                }
                catch (Exception e) {
                    SlowClusterStateProcessing.this.logger.error("error in background worker", (Throwable)e, new Object[0]);
                }
            }
        }
    }
}

