/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.engine;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.apache.lucene.index.FilterDirectoryReader;
import org.elasticsearch.common.inject.BindingAnnotation;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.EngineConfig;
import org.elasticsearch.index.engine.EngineFactory;
import org.elasticsearch.test.engine.MockInternalEngine;
import org.elasticsearch.test.engine.MockShadowEngine;

public final class MockEngineFactory
implements EngineFactory {
    private Class<? extends FilterDirectoryReader> wrapper;

    @Inject
    public MockEngineFactory(@MockReaderType Class wrapper) {
        this.wrapper = wrapper;
    }

    public Engine newReadWriteEngine(EngineConfig config, boolean skipTranslogRecovery) {
        return new MockInternalEngine(config, skipTranslogRecovery, this.wrapper);
    }

    public Engine newReadOnlyEngine(EngineConfig config) {
        return new MockShadowEngine(config, this.wrapper);
    }

    @BindingAnnotation
    @Target(value={ElementType.FIELD, ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface MockReaderType {
    }
}

