/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.geo;

import com.carrotsearch.randomizedtesting.generators.RandomInts;
import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.context.jts.JtsSpatialContext;
import com.spatial4j.core.distance.DistanceUtils;
import com.spatial4j.core.exception.InvalidShapeException;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Rectangle;
import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.SpatialRelation;
import com.spatial4j.core.shape.impl.Range;
import com.vividsolutions.jts.algorithm.ConvexHull;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import java.util.Random;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.geo.builders.BaseLineStringBuilder;
import org.elasticsearch.common.geo.builders.GeometryCollectionBuilder;
import org.elasticsearch.common.geo.builders.LineStringBuilder;
import org.elasticsearch.common.geo.builders.MultiLineStringBuilder;
import org.elasticsearch.common.geo.builders.MultiPointBuilder;
import org.elasticsearch.common.geo.builders.PointBuilder;
import org.elasticsearch.common.geo.builders.PolygonBuilder;
import org.elasticsearch.common.geo.builders.ShapeBuilder;
import org.elasticsearch.test.geo.RandomGeoGenerator;
import org.junit.Assert;

public class RandomShapeGenerator
extends RandomGeoGenerator {
    protected static JtsSpatialContext ctx = ShapeBuilder.SPATIAL_CONTEXT;
    protected static final double xDIVISIBLE = 2.0;
    protected static boolean ST_VALIDATE = true;

    public static ShapeBuilder createShape(Random r) throws InvalidShapeException {
        return RandomShapeGenerator.createShapeNear(r, null);
    }

    public static ShapeBuilder createShape(Random r, ShapeType st) {
        return RandomShapeGenerator.createShapeNear(r, null, st);
    }

    public static ShapeBuilder createShapeNear(Random r, Point nearPoint) throws InvalidShapeException {
        return RandomShapeGenerator.createShape(r, nearPoint, null, null);
    }

    public static ShapeBuilder createShapeNear(Random r, Point nearPoint, ShapeType st) throws InvalidShapeException {
        return RandomShapeGenerator.createShape(r, nearPoint, null, st);
    }

    public static ShapeBuilder createShapeWithin(Random r, Rectangle bbox) throws InvalidShapeException {
        return RandomShapeGenerator.createShape(r, null, bbox, null);
    }

    public static ShapeBuilder createShapeWithin(Random r, Rectangle bbox, ShapeType st) throws InvalidShapeException {
        return RandomShapeGenerator.createShape(r, null, bbox, st);
    }

    public static GeometryCollectionBuilder createGeometryCollection(Random r) throws InvalidShapeException {
        return RandomShapeGenerator.createGeometryCollection(r, null, null, 0);
    }

    public static GeometryCollectionBuilder createGeometryCollectionNear(Random r, Point nearPoint) throws InvalidShapeException {
        return RandomShapeGenerator.createGeometryCollection(r, nearPoint, null, 0);
    }

    public static GeometryCollectionBuilder createGeometryCollectionNear(Random r, Point nearPoint, int size) throws InvalidShapeException {
        return RandomShapeGenerator.createGeometryCollection(r, nearPoint, null, size);
    }

    public static GeometryCollectionBuilder createGeometryCollectionWithin(Random r, Rectangle within) throws InvalidShapeException {
        return RandomShapeGenerator.createGeometryCollection(r, null, within, 0);
    }

    public static GeometryCollectionBuilder createGeometryCollectionWithin(Random r, Rectangle within, int size) throws InvalidShapeException {
        return RandomShapeGenerator.createGeometryCollection(r, null, within, size);
    }

    protected static GeometryCollectionBuilder createGeometryCollection(Random r, Point nearPoint, Rectangle bounds, int numGeometries) throws InvalidShapeException {
        if (numGeometries <= 0) {
            numGeometries = RandomInts.randomIntBetween((Random)r, (int)2, (int)4);
        }
        if (nearPoint == null) {
            nearPoint = RandomShapeGenerator.xRandomPoint(r);
        }
        if (bounds == null) {
            bounds = RandomShapeGenerator.xRandomRectangle(r, nearPoint);
        }
        GeometryCollectionBuilder gcb = new GeometryCollectionBuilder();
        int i = 0;
        while (i < numGeometries) {
            ShapeBuilder builder = RandomShapeGenerator.createShapeWithin(r, bounds);
            if (builder == null) continue;
            gcb.shape(builder);
            ++i;
        }
        return gcb;
    }

    private static ShapeBuilder createShape(Random r, Point nearPoint, Rectangle within, ShapeType st) throws InvalidShapeException {
        int i = 0;
        do {
            ShapeBuilder shape;
            if ((shape = RandomShapeGenerator.createShape(r, nearPoint, within, st, ST_VALIDATE)) == null) continue;
            return shape;
        } while ((i = (int)((short)(i + 1))) != 100);
        throw new InvalidShapeException("Unable to create a valid random shape with provided seed");
    }

    private static ShapeBuilder createShape(Random r, Point nearPoint, Rectangle within, ShapeType st, boolean validate) throws InvalidShapeException {
        if (st == null) {
            st = ShapeType.randomType(r);
        }
        if (within == null) {
            within = RandomShapeGenerator.xRandomRectangle(r, nearPoint);
        }
        switch (st) {
            case POINT: {
                Point p = RandomShapeGenerator.xRandomPointIn(r, within);
                PointBuilder pb = new PointBuilder().coordinate(new Coordinate(p.getX(), p.getY(), Double.NaN));
                return pb;
            }
            case MULTIPOINT: 
            case LINESTRING: {
                int numPoints = RandomInts.randomIntBetween((Random)r, (int)3, (int)10);
                MultiPointBuilder pcb = st == ShapeType.MULTIPOINT ? new MultiPointBuilder() : new LineStringBuilder();
                for (int i = 0; i < numPoints; ++i) {
                    Point p = RandomShapeGenerator.xRandomPointIn(r, within);
                    pcb.point(p.getX(), p.getY());
                }
                return pcb;
            }
            case MULTILINESTRING: {
                MultiLineStringBuilder mlsb = new MultiLineStringBuilder();
                for (int i = 0; i < RandomInts.randomIntBetween((Random)r, (int)1, (int)10); ++i) {
                    mlsb.linestring((BaseLineStringBuilder)RandomShapeGenerator.createShape(r, nearPoint, within, ShapeType.LINESTRING, false));
                }
                return mlsb;
            }
            case POLYGON: {
                int numPoints = RandomInts.randomIntBetween((Random)r, (int)5, (int)25);
                Coordinate[] coordinates = new Coordinate[numPoints];
                for (int i = 0; i < numPoints; ++i) {
                    Point p = (Point)RandomShapeGenerator.createShape(r, nearPoint, within, ShapeType.POINT, false).build();
                    coordinates[i] = new Coordinate(p.getX(), p.getY());
                }
                Geometry shell = new ConvexHull(coordinates, ctx.getGeometryFactory()).getConvexHull();
                Coordinate[] shellCoords = shell.getCoordinates();
                if (shellCoords.length < 3) {
                    shellCoords = new Coordinate[]{new Coordinate(within.getMinX(), within.getMinY()), new Coordinate(within.getMinX(), within.getMaxY()), new Coordinate(within.getMaxX(), within.getMaxY()), new Coordinate(within.getMaxX(), within.getMinY())};
                }
                PolygonBuilder pgb = ((PolygonBuilder)new PolygonBuilder().points(shellCoords)).close();
                if (validate) {
                    try {
                        pgb.build();
                    }
                    catch (Throwable e) {
                        if (e instanceof InvalidShapeException || e instanceof AssertionError) {
                            return null;
                        }
                        throw e;
                    }
                }
                return pgb;
            }
        }
        throw new ElasticsearchException("Unable to create shape of type [" + (Object)((Object)st) + "]", new Object[0]);
    }

    public static Point xRandomPoint(Random r) {
        return RandomShapeGenerator.xRandomPointIn(r, ctx.getWorldBounds());
    }

    protected static Point xRandomPointIn(Random rand, Rectangle r) {
        double[] pt = new double[2];
        RandomShapeGenerator.randomPointIn(rand, r.getMinX(), r.getMinY(), r.getMaxX(), r.getMaxY(), pt);
        Point p = ctx.makePoint(pt[0], pt[1]);
        Assert.assertEquals((Object)SpatialRelation.CONTAINS, (Object)r.relate((Shape)p));
        return p;
    }

    private static Rectangle xRandomRectangle(Random r, Point nearP, Rectangle bounds, boolean small) {
        if (nearP == null) {
            nearP = RandomShapeGenerator.xRandomPointIn(r, bounds);
        }
        if (small) {
            double latRange = 3.0 * r.nextDouble() + 3.0;
            double lonRange = 3.0 * r.nextDouble() + 3.0;
            double minX = nearP.getX();
            double maxX = minX + lonRange;
            if (maxX > 180.0) {
                maxX = minX;
                minX -= lonRange;
            }
            double minY = nearP.getY();
            double maxY = nearP.getY() + latRange;
            if (maxY > 90.0) {
                maxY = minY;
                minY -= latRange;
            }
            return ctx.makeRectangle(minX, maxX, minY, maxY);
        }
        Range xRange = RandomShapeGenerator.xRandomRange(r, RandomShapeGenerator.rarely(r) ? 0.0 : nearP.getX(), Range.xRange((Rectangle)bounds, (SpatialContext)ctx));
        Range yRange = RandomShapeGenerator.xRandomRange(r, RandomShapeGenerator.rarely(r) ? 0.0 : nearP.getY(), Range.yRange((Rectangle)bounds, (SpatialContext)ctx));
        return RandomShapeGenerator.xMakeNormRect(RandomShapeGenerator.xDivisible(xRange.getMin() * 10000.0) / 10000.0, RandomShapeGenerator.xDivisible(xRange.getMax() * 10000.0) / 10000.0, RandomShapeGenerator.xDivisible(yRange.getMin() * 10000.0) / 10000.0, RandomShapeGenerator.xDivisible(yRange.getMax() * 10000.0) / 10000.0);
    }

    public static Rectangle xRandomRectangle(Random r, Point nearP) {
        return RandomShapeGenerator.xRandomRectangle(r, nearP, ctx.getWorldBounds(), true);
    }

    public static Rectangle xRandomRectangle(Random r, Point nearP, boolean small) {
        return RandomShapeGenerator.xRandomRectangle(r, nearP, ctx.getWorldBounds(), small);
    }

    private static boolean rarely(Random r) {
        return RandomInts.randomInt((Random)r, (int)100) >= 90;
    }

    private static Range xRandomRange(Random r, double near, Range bounds) {
        double mid = near + r.nextGaussian() * bounds.getWidth() / 6.0;
        double width = Math.abs(r.nextGaussian()) * bounds.getWidth() / 6.0;
        return new Range(mid - width / 2.0, mid + width / 2.0);
    }

    private static double xDivisible(double v, double divisible) {
        return (int)((double)Math.round(v / divisible) * divisible);
    }

    private static double xDivisible(double v) {
        return RandomShapeGenerator.xDivisible(v, 2.0);
    }

    protected static Rectangle xMakeNormRect(double minX, double maxX, double minY, double maxY) {
        minX = DistanceUtils.normLonDEG((double)minX);
        if ((maxX = DistanceUtils.normLonDEG((double)maxX)) < minX) {
            double t = minX;
            minX = maxX;
            maxX = t;
        }
        double minWorldY = ctx.getWorldBounds().getMinY();
        double maxWorldY = ctx.getWorldBounds().getMaxY();
        if (minY < minWorldY || minY > maxWorldY) {
            minY = DistanceUtils.normLatDEG((double)minY);
        }
        if (maxY < minWorldY || maxY > maxWorldY) {
            maxY = DistanceUtils.normLatDEG((double)maxY);
        }
        if (maxY < minY) {
            double t = minY;
            minY = maxY;
            maxY = t;
        }
        return ctx.makeRectangle(minX, maxX, minY, maxY);
    }

    public static enum ShapeType {
        POINT,
        MULTIPOINT,
        LINESTRING,
        MULTILINESTRING,
        POLYGON;

        private static final ShapeType[] types;

        public static ShapeType randomType(Random r) {
            return types[RandomInts.randomIntBetween((Random)r, (int)0, (int)(types.length - 1))];
        }

        static {
            types = ShapeType.values();
        }
    }
}

