/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.hamcrest;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequestBuilder;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.elasticsearch.action.admin.cluster.node.info.PluginsAndModules;
import org.elasticsearch.action.admin.indices.alias.exists.AliasesExistResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexResponse;
import org.elasticsearch.action.admin.indices.template.get.GetIndexTemplatesResponse;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.count.CountResponse;
import org.elasticsearch.action.exists.ExistsResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.percolate.PercolateResponse;
import org.elasticsearch.action.search.SearchPhaseExecutionException;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.action.support.broadcast.BroadcastResponse;
import org.elasticsearch.action.support.master.AcknowledgedRequestBuilder;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.metadata.IndexTemplateMetaData;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.plugins.PluginInfo;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.highlight.HighlightField;
import org.elasticsearch.search.suggest.Suggest;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.VersionUtils;
import org.elasticsearch.test.hamcrest.ElasticsearchMatchers;
import org.elasticsearch.test.rest.client.http.HttpResponse;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class ElasticsearchAssertions {
    private static Predicate<PluginInfo> jvmPluginPredicate = new Predicate<PluginInfo>(){

        public boolean apply(PluginInfo pluginInfo) {
            return pluginInfo.isJvm();
        }
    };
    private static Predicate<PluginInfo> sitePluginPredicate = new Predicate<PluginInfo>(){

        public boolean apply(PluginInfo pluginInfo) {
            return pluginInfo.isSite();
        }
    };
    private static Function<PluginInfo, String> nameFunction = new Function<PluginInfo, String>(){

        public String apply(PluginInfo pluginInfo) {
            return pluginInfo.getName();
        }
    };
    private static Function<PluginInfo, String> descriptionFunction = new Function<PluginInfo, String>(){

        public String apply(PluginInfo pluginInfo) {
            return pluginInfo.getDescription();
        }
    };
    private static Function<PluginInfo, String> urlFunction = new Function<PluginInfo, String>(){

        public String apply(PluginInfo pluginInfo) {
            return pluginInfo.getUrl();
        }
    };
    private static Function<PluginInfo, String> versionFunction = new Function<PluginInfo, String>(){

        public String apply(PluginInfo pluginInfo) {
            return pluginInfo.getVersion();
        }
    };

    public static void assertAcked(AcknowledgedRequestBuilder<?, ?, ?> builder) {
        ElasticsearchAssertions.assertAcked((AcknowledgedResponse)builder.get());
    }

    public static void assertNoTimeout(ClusterHealthRequestBuilder requestBuilder) {
        ElasticsearchAssertions.assertNoTimeout((ClusterHealthResponse)requestBuilder.get());
    }

    public static void assertNoTimeout(ClusterHealthResponse response) {
        MatcherAssert.assertThat((String)("ClusterHealthResponse has timed out - returned: [" + response + "]"), (Object)response.isTimedOut(), (Matcher)CoreMatchers.is((Object)false));
    }

    public static void assertAcked(AcknowledgedResponse response) {
        MatcherAssert.assertThat((String)(response.getClass().getSimpleName() + " failed - not acked"), (Object)response.isAcknowledged(), (Matcher)CoreMatchers.equalTo((Object)true));
        ElasticsearchAssertions.assertVersionSerializable((Streamable)response);
    }

    public static void assertAcked(DeleteIndexRequestBuilder builder) {
        ElasticsearchAssertions.assertAcked((DeleteIndexResponse)builder.get());
    }

    public static void assertAcked(DeleteIndexResponse response) {
        MatcherAssert.assertThat((String)"Delete Index failed - not acked", (Object)response.isAcknowledged(), (Matcher)CoreMatchers.equalTo((Object)true));
        ElasticsearchAssertions.assertVersionSerializable((Streamable)response);
    }

    public static void assertBlocked(ActionRequestBuilder builder) {
        ElasticsearchAssertions.assertBlocked(builder, null);
    }

    public static void assertBlocked(BroadcastResponse replicatedBroadcastResponse) {
        MatcherAssert.assertThat((String)"all shard requests should have failed", (Object)replicatedBroadcastResponse.getFailedShards(), (Matcher)Matchers.equalTo((Object)replicatedBroadcastResponse.getTotalShards()));
        for (ShardOperationFailedException exception : replicatedBroadcastResponse.getShardFailures()) {
            ClusterBlockException clusterBlockException = (ClusterBlockException)ExceptionsHelper.unwrap((Throwable)exception.getCause(), (Class[])new Class[]{ClusterBlockException.class});
            ESTestCase.assertNotNull((String)("expected the cause of failure to be a ClusterBlockException but got " + exception.getCause().getMessage()), (Object)clusterBlockException);
            MatcherAssert.assertThat((Object)clusterBlockException.blocks().size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
            MatcherAssert.assertThat((Object)clusterBlockException.status(), (Matcher)CoreMatchers.equalTo((Object)RestStatus.FORBIDDEN));
        }
    }

    public static void assertBlocked(ActionRequestBuilder builder, ClusterBlock expectedBlock) {
        block3: {
            try {
                builder.get();
                ESTestCase.fail((String)"Request executed with success but a ClusterBlockException was expected");
            }
            catch (ClusterBlockException e) {
                MatcherAssert.assertThat((Object)e.blocks().size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
                MatcherAssert.assertThat((Object)e.status(), (Matcher)CoreMatchers.equalTo((Object)RestStatus.FORBIDDEN));
                if (expectedBlock == null) break block3;
                boolean found = false;
                for (ClusterBlock clusterBlock : e.blocks()) {
                    if (clusterBlock.id() != expectedBlock.id()) continue;
                    found = true;
                    break;
                }
                MatcherAssert.assertThat((String)("Request should have been blocked by [" + expectedBlock + "] instead of " + e.blocks()), (Object)found, (Matcher)CoreMatchers.equalTo((Object)true));
            }
        }
    }

    public static String formatShardStatus(BroadcastResponse response) {
        String msg = " Total shards: " + response.getTotalShards() + " Successful shards: " + response.getSuccessfulShards() + " & " + response.getFailedShards() + " shard failures:";
        for (ShardOperationFailedException failure : response.getShardFailures()) {
            msg = msg + "\n " + failure.toString();
        }
        return msg;
    }

    public static String formatShardStatus(SearchResponse response) {
        String msg = " Total shards: " + response.getTotalShards() + " Successful shards: " + response.getSuccessfulShards() + " & " + response.getFailedShards() + " shard failures:";
        for (ShardSearchFailure failure : response.getShardFailures()) {
            msg = msg + "\n " + failure.toString();
        }
        return msg;
    }

    public static void assertHitCount(SearchResponse searchResponse, long expectedHitCount) {
        if (searchResponse.getHits().totalHits() != expectedHitCount) {
            ESTestCase.fail((String)("Hit count is " + searchResponse.getHits().totalHits() + " but " + expectedHitCount + " was expected. " + ElasticsearchAssertions.formatShardStatus(searchResponse)));
        }
        ElasticsearchAssertions.assertVersionSerializable((Streamable)searchResponse);
    }

    public static void assertNoSearchHits(SearchResponse searchResponse) {
        ESTestCase.assertEquals((long)0L, (long)searchResponse.getHits().getHits().length);
    }

    public static void assertSearchHits(SearchResponse searchResponse, String ... ids) {
        String shardStatus = ElasticsearchAssertions.formatShardStatus(searchResponse);
        HashSet<String> idsSet = new HashSet<String>(Arrays.asList(ids));
        for (SearchHit hit : searchResponse.getHits()) {
            MatcherAssert.assertThat((String)("id [" + hit.getId() + "] was found in search results but wasn't expected (type [" + hit.getType() + "], index [" + hit.index() + "])" + shardStatus), (Object)idsSet.remove(hit.getId()), (Matcher)CoreMatchers.equalTo((Object)true));
        }
        MatcherAssert.assertThat((String)("Some expected ids were not found in search results: " + Arrays.toString(idsSet.toArray(new String[idsSet.size()])) + "." + shardStatus), (Object)idsSet.size(), (Matcher)CoreMatchers.equalTo((Object)0));
        ElasticsearchAssertions.assertVersionSerializable((Streamable)searchResponse);
    }

    public static void assertSortValues(SearchResponse searchResponse, Object[] ... sortValues) {
        ElasticsearchAssertions.assertSearchResponse(searchResponse);
        SearchHit[] hits = searchResponse.getHits().getHits();
        ESTestCase.assertEquals((long)sortValues.length, (long)hits.length);
        for (int i = 0; i < sortValues.length; ++i) {
            Object[] hitsSortValues = hits[i].getSortValues();
            ESTestCase.assertArrayEquals((String)("Offset " + Integer.toString(i) + ", id " + hits[i].getId()), (Object[])sortValues[i], (Object[])hitsSortValues);
        }
        ElasticsearchAssertions.assertVersionSerializable((Streamable)searchResponse);
    }

    public static void assertOrderedSearchHits(SearchResponse searchResponse, String ... ids) {
        String shardStatus = ElasticsearchAssertions.formatShardStatus(searchResponse);
        MatcherAssert.assertThat((String)("Expected different hit count. " + shardStatus), (Object)searchResponse.getHits().hits().length, (Matcher)CoreMatchers.equalTo((Object)ids.length));
        for (int i = 0; i < ids.length; ++i) {
            SearchHit hit = searchResponse.getHits().hits()[i];
            MatcherAssert.assertThat((String)("Expected id: " + ids[i] + " at position " + i + " but wasn't." + shardStatus), (Object)hit.getId(), (Matcher)CoreMatchers.equalTo((Object)ids[i]));
        }
        ElasticsearchAssertions.assertVersionSerializable((Streamable)searchResponse);
    }

    public static void assertHitCount(CountResponse countResponse, long expectedHitCount) {
        if (countResponse.getCount() != expectedHitCount) {
            ESTestCase.fail((String)("Count is " + countResponse.getCount() + " but " + expectedHitCount + " was expected. " + ElasticsearchAssertions.formatShardStatus((BroadcastResponse)countResponse)));
        }
        ElasticsearchAssertions.assertVersionSerializable((Streamable)countResponse);
    }

    public static void assertExists(ExistsResponse existsResponse, boolean expected) {
        if (existsResponse.exists() != expected) {
            ESTestCase.fail((String)("Exist is " + existsResponse.exists() + " but " + expected + " was expected " + ElasticsearchAssertions.formatShardStatus((BroadcastResponse)existsResponse)));
        }
        ElasticsearchAssertions.assertVersionSerializable((Streamable)existsResponse);
    }

    public static void assertMatchCount(PercolateResponse percolateResponse, long expectedHitCount) {
        if (percolateResponse.getCount() != expectedHitCount) {
            ESTestCase.fail((String)("Count is " + percolateResponse.getCount() + " but " + expectedHitCount + " was expected. " + ElasticsearchAssertions.formatShardStatus((BroadcastResponse)percolateResponse)));
        }
        ElasticsearchAssertions.assertVersionSerializable((Streamable)percolateResponse);
    }

    public static void assertExists(GetResponse response) {
        String message = String.format(Locale.ROOT, "Expected %s/%s/%s to exist, but does not", response.getIndex(), response.getType(), response.getId());
        MatcherAssert.assertThat((String)message, (Object)response.isExists(), (Matcher)CoreMatchers.is((Object)true));
    }

    public static void assertFirstHit(SearchResponse searchResponse, Matcher<SearchHit> matcher) {
        ElasticsearchAssertions.assertSearchHit(searchResponse, 1, matcher);
    }

    public static void assertSecondHit(SearchResponse searchResponse, Matcher<SearchHit> matcher) {
        ElasticsearchAssertions.assertSearchHit(searchResponse, 2, matcher);
    }

    public static void assertThirdHit(SearchResponse searchResponse, Matcher<SearchHit> matcher) {
        ElasticsearchAssertions.assertSearchHit(searchResponse, 3, matcher);
    }

    public static void assertFourthHit(SearchResponse searchResponse, Matcher<SearchHit> matcher) {
        ElasticsearchAssertions.assertSearchHit(searchResponse, 4, matcher);
    }

    public static void assertFifthHit(SearchResponse searchResponse, Matcher<SearchHit> matcher) {
        ElasticsearchAssertions.assertSearchHit(searchResponse, 5, matcher);
    }

    public static void assertSearchHit(SearchResponse searchResponse, int number, Matcher<SearchHit> matcher) {
        MatcherAssert.assertThat((Object)number, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((String)"SearchHit number must be greater than 0", (Object)number, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)searchResponse.getHits().totalHits(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(number)));
        ElasticsearchAssertions.assertSearchHit(searchResponse.getHits().getAt(number - 1), matcher);
        ElasticsearchAssertions.assertVersionSerializable((Streamable)searchResponse);
    }

    public static void assertNoFailures(SearchResponse searchResponse) {
        MatcherAssert.assertThat((String)("Unexpected ShardFailures: " + Arrays.toString(searchResponse.getShardFailures())), (Object)searchResponse.getShardFailures().length, (Matcher)CoreMatchers.equalTo((Object)0));
        ElasticsearchAssertions.assertVersionSerializable((Streamable)searchResponse);
    }

    public static void assertFailures(SearchResponse searchResponse) {
        MatcherAssert.assertThat((String)"Expected at least one shard failure, got none", (Object)searchResponse.getShardFailures().length, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        ElasticsearchAssertions.assertVersionSerializable((Streamable)searchResponse);
    }

    public static void assertNoFailures(BulkResponse response) {
        MatcherAssert.assertThat((String)("Unexpected ShardFailures: " + response.buildFailureMessage()), (Object)response.hasFailures(), (Matcher)CoreMatchers.is((Object)false));
        ElasticsearchAssertions.assertVersionSerializable((Streamable)response);
    }

    public static void assertFailures(SearchRequestBuilder searchRequestBuilder, RestStatus restStatus, Matcher<String> reasonMatcher) {
        try {
            SearchResponse searchResponse = (SearchResponse)searchRequestBuilder.get();
            MatcherAssert.assertThat((String)"Expected shard failures, got none", (Object)searchResponse.getShardFailures().length, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
            for (ShardSearchFailure shardSearchFailure : searchResponse.getShardFailures()) {
                MatcherAssert.assertThat((Object)shardSearchFailure.status(), (Matcher)CoreMatchers.equalTo((Object)restStatus));
                MatcherAssert.assertThat((Object)shardSearchFailure.reason(), reasonMatcher);
            }
            ElasticsearchAssertions.assertVersionSerializable((Streamable)searchResponse);
        }
        catch (SearchPhaseExecutionException e) {
            MatcherAssert.assertThat((Object)e.status(), (Matcher)CoreMatchers.equalTo((Object)restStatus));
            MatcherAssert.assertThat((Object)e.toString(), reasonMatcher);
            for (ShardSearchFailure shardSearchFailure : e.shardFailures()) {
                MatcherAssert.assertThat((Object)shardSearchFailure.status(), (Matcher)CoreMatchers.equalTo((Object)restStatus));
                MatcherAssert.assertThat((Object)shardSearchFailure.reason(), reasonMatcher);
            }
        }
        catch (Exception e) {
            ESTestCase.fail((String)("SearchPhaseExecutionException expected but got " + e.getClass()));
        }
    }

    public static void assertFailures(PercolateResponse percolateResponse) {
        MatcherAssert.assertThat((String)"Expected at least one shard failure, got none", (Object)percolateResponse.getShardFailures().length, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        ElasticsearchAssertions.assertVersionSerializable((Streamable)percolateResponse);
    }

    public static void assertNoFailures(BroadcastResponse response) {
        MatcherAssert.assertThat((String)("Unexpected ShardFailures: " + Arrays.toString(response.getShardFailures())), (Object)response.getFailedShards(), (Matcher)CoreMatchers.equalTo((Object)0));
        ElasticsearchAssertions.assertVersionSerializable((Streamable)response);
    }

    public static void assertAllSuccessful(BroadcastResponse response) {
        ElasticsearchAssertions.assertNoFailures(response);
        MatcherAssert.assertThat((String)("Expected all shards successful but got successful [" + response.getSuccessfulShards() + "] total [" + response.getTotalShards() + "]"), (Object)response.getTotalShards(), (Matcher)CoreMatchers.equalTo((Object)response.getSuccessfulShards()));
        ElasticsearchAssertions.assertVersionSerializable((Streamable)response);
    }

    public static void assertAllSuccessful(SearchResponse response) {
        ElasticsearchAssertions.assertNoFailures(response);
        MatcherAssert.assertThat((String)("Expected all shards successful but got successful [" + response.getSuccessfulShards() + "] total [" + response.getTotalShards() + "]"), (Object)response.getTotalShards(), (Matcher)CoreMatchers.equalTo((Object)response.getSuccessfulShards()));
        ElasticsearchAssertions.assertVersionSerializable((Streamable)response);
    }

    public static void assertSearchHit(SearchHit searchHit, Matcher<SearchHit> matcher) {
        MatcherAssert.assertThat((Object)searchHit, matcher);
        ElasticsearchAssertions.assertVersionSerializable((Streamable)searchHit);
    }

    public static void assertHighlight(SearchResponse resp, int hit, String field, int fragment, Matcher<String> matcher) {
        ElasticsearchAssertions.assertHighlight(resp, hit, field, fragment, (Matcher<Integer>)Matchers.greaterThan((Comparable)Integer.valueOf(fragment)), matcher);
    }

    public static void assertHighlight(SearchResponse resp, int hit, String field, int fragment, int totalFragments, Matcher<String> matcher) {
        ElasticsearchAssertions.assertHighlight(resp, hit, field, fragment, (Matcher<Integer>)CoreMatchers.equalTo((Object)totalFragments), matcher);
    }

    public static void assertHighlight(SearchHit hit, String field, int fragment, Matcher<String> matcher) {
        ElasticsearchAssertions.assertHighlight(hit, field, fragment, (Matcher<Integer>)Matchers.greaterThan((Comparable)Integer.valueOf(fragment)), matcher);
    }

    public static void assertHighlight(SearchHit hit, String field, int fragment, int totalFragments, Matcher<String> matcher) {
        ElasticsearchAssertions.assertHighlight(hit, field, fragment, (Matcher<Integer>)CoreMatchers.equalTo((Object)totalFragments), matcher);
    }

    private static void assertHighlight(SearchResponse resp, int hit, String field, int fragment, Matcher<Integer> fragmentsMatcher, Matcher<String> matcher) {
        ElasticsearchAssertions.assertNoFailures(resp);
        MatcherAssert.assertThat((String)"not enough hits", (Object)resp.getHits().hits().length, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(hit)));
        ElasticsearchAssertions.assertHighlight(resp.getHits().hits()[hit], field, fragment, fragmentsMatcher, matcher);
        ElasticsearchAssertions.assertVersionSerializable((Streamable)resp);
    }

    private static void assertHighlight(SearchHit hit, String field, int fragment, Matcher<Integer> fragmentsMatcher, Matcher<String> matcher) {
        MatcherAssert.assertThat((Object)hit.getHighlightFields(), (Matcher)Matchers.hasKey((Object)field));
        MatcherAssert.assertThat((Object)((HighlightField)hit.getHighlightFields().get(field)).fragments().length, fragmentsMatcher);
        MatcherAssert.assertThat((Object)((HighlightField)hit.highlightFields().get(field)).fragments()[fragment].string(), matcher);
    }

    public static void assertNotHighlighted(SearchResponse resp, int hit, String field) {
        ElasticsearchAssertions.assertNoFailures(resp);
        MatcherAssert.assertThat((String)"not enough hits", (Object)resp.getHits().hits().length, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(hit)));
        MatcherAssert.assertThat((Object)resp.getHits().hits()[hit].getHighlightFields(), (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)field)));
    }

    public static void assertSuggestionSize(Suggest searchSuggest, int entry, int size, String key) {
        MatcherAssert.assertThat((Object)searchSuggest, (Matcher)Matchers.notNullValue());
        String msg = "Suggest result: " + searchSuggest.toString();
        MatcherAssert.assertThat((String)msg, (Object)searchSuggest.size(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
        MatcherAssert.assertThat((String)msg, (Object)searchSuggest.getSuggestion(key).getName(), (Matcher)CoreMatchers.equalTo((Object)key));
        MatcherAssert.assertThat((String)msg, (Object)searchSuggest.getSuggestion(key).getEntries().size(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(entry)));
        MatcherAssert.assertThat((String)msg, (Object)((Suggest.Suggestion.Entry)searchSuggest.getSuggestion(key).getEntries().get(entry)).getOptions().size(), (Matcher)CoreMatchers.equalTo((Object)size));
        ElasticsearchAssertions.assertVersionSerializable((Streamable)searchSuggest);
    }

    public static void assertSuggestionPhraseCollateMatchExists(Suggest searchSuggest, String key, int numberOfPhraseExists) {
        int counter = 0;
        MatcherAssert.assertThat((Object)searchSuggest, (Matcher)Matchers.notNullValue());
        String msg = "Suggest result: " + searchSuggest.toString();
        MatcherAssert.assertThat((String)msg, (Object)searchSuggest.size(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
        MatcherAssert.assertThat((String)msg, (Object)searchSuggest.getSuggestion(key).getName(), (Matcher)CoreMatchers.equalTo((Object)key));
        for (Suggest.Suggestion.Entry.Option option : ((Suggest.Suggestion.Entry)searchSuggest.getSuggestion(key).getEntries().get(0)).getOptions()) {
            if (!option.collateMatch()) continue;
            ++counter;
        }
        MatcherAssert.assertThat((Object)counter, (Matcher)CoreMatchers.equalTo((Object)numberOfPhraseExists));
    }

    public static void assertSuggestion(Suggest searchSuggest, int entry, int ord, String key, String text) {
        MatcherAssert.assertThat((Object)searchSuggest, (Matcher)Matchers.notNullValue());
        String msg = "Suggest result: " + searchSuggest.toString();
        MatcherAssert.assertThat((String)msg, (Object)searchSuggest.size(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
        MatcherAssert.assertThat((String)msg, (Object)searchSuggest.getSuggestion(key).getName(), (Matcher)CoreMatchers.equalTo((Object)key));
        MatcherAssert.assertThat((String)msg, (Object)searchSuggest.getSuggestion(key).getEntries().size(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(entry)));
        MatcherAssert.assertThat((String)msg, (Object)((Suggest.Suggestion.Entry)searchSuggest.getSuggestion(key).getEntries().get(entry)).getOptions().size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(ord)));
        MatcherAssert.assertThat((String)msg, (Object)((Suggest.Suggestion.Entry.Option)((Suggest.Suggestion.Entry)searchSuggest.getSuggestion(key).getEntries().get(entry)).getOptions().get(ord)).getText().string(), (Matcher)CoreMatchers.equalTo((Object)text));
        ElasticsearchAssertions.assertVersionSerializable((Streamable)searchSuggest);
    }

    public static void assertSuggestion(Suggest searchSuggest, int entry, String key, String ... text) {
        ElasticsearchAssertions.assertSuggestion(searchSuggest, entry, key, text.length, text);
    }

    public static void assertSuggestion(Suggest searchSuggest, int entry, String key, int size, String ... text) {
        ElasticsearchAssertions.assertSuggestionSize(searchSuggest, entry, size, key);
        for (int i = 0; i < text.length; ++i) {
            ElasticsearchAssertions.assertSuggestion(searchSuggest, entry, i, key, text[i]);
        }
    }

    public static void assertIndexTemplateMissing(GetIndexTemplatesResponse templatesResponse, String name) {
        ArrayList<String> templateNames = new ArrayList<String>();
        for (IndexTemplateMetaData indexTemplateMetaData : templatesResponse.getIndexTemplates()) {
            templateNames.add(indexTemplateMetaData.name());
        }
        MatcherAssert.assertThat(templateNames, (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)name)));
    }

    public static void assertIndexTemplateExists(GetIndexTemplatesResponse templatesResponse, String name) {
        ArrayList<String> templateNames = new ArrayList<String>();
        for (IndexTemplateMetaData indexTemplateMetaData : templatesResponse.getIndexTemplates()) {
            templateNames.add(indexTemplateMetaData.name());
        }
        MatcherAssert.assertThat(templateNames, (Matcher)Matchers.hasItem((Object)name));
    }

    public static void assertAliasesMissing(AliasesExistResponse aliasesExistResponse) {
        ESTestCase.assertFalse((String)"Aliases shouldn't exist", (boolean)aliasesExistResponse.exists());
    }

    public static void assertAliasesExist(AliasesExistResponse aliasesExistResponse) {
        ESTestCase.assertTrue((String)"Aliases should exist", (boolean)aliasesExistResponse.exists());
    }

    public static Matcher<SearchHit> hasId(String id) {
        return new ElasticsearchMatchers.SearchHitHasIdMatcher(id);
    }

    public static Matcher<SearchHit> hasType(String type) {
        return new ElasticsearchMatchers.SearchHitHasTypeMatcher(type);
    }

    public static Matcher<SearchHit> hasIndex(String index) {
        return new ElasticsearchMatchers.SearchHitHasIndexMatcher(index);
    }

    public static Matcher<SearchHit> hasScore(float score) {
        return new ElasticsearchMatchers.SearchHitHasScoreMatcher(score);
    }

    public static Matcher<HttpResponse> hasStatus(RestStatus restStatus) {
        return new ElasticsearchMatchers.HttpResponseHasStatusMatcher(restStatus);
    }

    public static <T extends Query> T assertBooleanSubQuery(Query query, Class<T> subqueryType, int i) {
        MatcherAssert.assertThat((Object)query, (Matcher)Matchers.instanceOf(BooleanQuery.class));
        BooleanQuery q = (BooleanQuery)query;
        MatcherAssert.assertThat((Object)q.getClauses().length, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(i)));
        MatcherAssert.assertThat((Object)q.getClauses()[i].getQuery(), (Matcher)Matchers.instanceOf(subqueryType));
        return (T)q.getClauses()[i].getQuery();
    }

    public static <E extends Throwable> void assertThrows(ActionRequestBuilder<?, ?, ?> builder, Class<E> exceptionClass) {
        ElasticsearchAssertions.assertThrows((ActionFuture)builder.execute(), exceptionClass);
    }

    public static <E extends Throwable> void assertThrows(ActionRequestBuilder<?, ?, ?> builder, Class<E> exceptionClass, RestStatus status) {
        ElasticsearchAssertions.assertThrows((ActionFuture)builder.execute(), exceptionClass, status);
    }

    public static <E extends Throwable> void assertThrows(ActionRequestBuilder<?, ?, ?> builder, Class<E> exceptionClass, String extraInfo) {
        ElasticsearchAssertions.assertThrows((ActionFuture)builder.execute(), exceptionClass, extraInfo);
    }

    public static <E extends Throwable> void assertThrows(ActionFuture future, Class<E> exceptionClass) {
        ElasticsearchAssertions.assertThrows(future, exceptionClass, null, null);
    }

    public static <E extends Throwable> void assertThrows(ActionFuture future, Class<E> exceptionClass, RestStatus status) {
        ElasticsearchAssertions.assertThrows(future, exceptionClass, status, null);
    }

    public static <E extends Throwable> void assertThrows(ActionFuture future, Class<E> exceptionClass, String extraInfo) {
        ElasticsearchAssertions.assertThrows(future, exceptionClass, null, extraInfo);
    }

    public static <E extends Throwable> void assertThrows(ActionFuture future, Class<E> exceptionClass, @Nullable RestStatus status, @Nullable String extraInfo) {
        boolean fail;
        block6: {
            fail = false;
            extraInfo = extraInfo == null || extraInfo.isEmpty() ? "" : extraInfo + ": ";
            extraInfo = extraInfo + "expected a " + exceptionClass + " exception to be thrown";
            if (status != null) {
                extraInfo = extraInfo + " with status [" + status + "]";
            }
            try {
                future.actionGet();
                fail = true;
            }
            catch (ElasticsearchException esException) {
                MatcherAssert.assertThat((String)extraInfo, (Object)esException.unwrapCause(), (Matcher)Matchers.instanceOf(exceptionClass));
                if (status != null) {
                    MatcherAssert.assertThat((String)extraInfo, (Object)ExceptionsHelper.status((Throwable)esException), (Matcher)CoreMatchers.equalTo((Object)status));
                }
            }
            catch (Throwable e) {
                MatcherAssert.assertThat((String)extraInfo, (Object)e, (Matcher)Matchers.instanceOf(exceptionClass));
                if (status == null) break block6;
                MatcherAssert.assertThat((String)extraInfo, (Object)ExceptionsHelper.status((Throwable)e), (Matcher)CoreMatchers.equalTo((Object)status));
            }
        }
        if (fail) {
            throw new AssertionError((Object)extraInfo);
        }
    }

    public static <E extends Throwable> void assertThrows(ActionRequestBuilder<?, ?, ?> builder, RestStatus status) {
        ElasticsearchAssertions.assertThrows((ActionFuture)builder.execute(), status);
    }

    public static <E extends Throwable> void assertThrows(ActionRequestBuilder<?, ?, ?> builder, RestStatus status, String extraInfo) {
        ElasticsearchAssertions.assertThrows((ActionFuture)builder.execute(), status, extraInfo);
    }

    public static <E extends Throwable> void assertThrows(ActionFuture future, RestStatus status) {
        ElasticsearchAssertions.assertThrows(future, status, null);
    }

    public static void assertThrows(ActionFuture future, RestStatus status, String extraInfo) {
        boolean fail = false;
        extraInfo = extraInfo == null || extraInfo.isEmpty() ? "" : extraInfo + ": ";
        extraInfo = extraInfo + "expected a " + status + " status exception to be thrown";
        try {
            future.actionGet();
            fail = true;
        }
        catch (Throwable e) {
            MatcherAssert.assertThat((String)extraInfo, (Object)ExceptionsHelper.status((Throwable)e), (Matcher)CoreMatchers.equalTo((Object)status));
        }
        if (fail) {
            throw new AssertionError((Object)extraInfo);
        }
    }

    private static BytesReference serialize(Version version, Streamable streamable) throws IOException {
        BytesStreamOutput output = new BytesStreamOutput();
        output.setVersion(version);
        streamable.writeTo((StreamOutput)output);
        output.flush();
        return output.bytes();
    }

    public static void assertVersionSerializable(Streamable streamable) {
        ESTestCase.assertTrue((boolean)Version.CURRENT.after(VersionUtils.getPreviousVersion()));
        ElasticsearchAssertions.assertVersionSerializable(VersionUtils.randomVersion(ESTestCase.random()), streamable);
    }

    public static void assertVersionSerializable(Version version, Streamable streamable) {
        try {
            Streamable newInstance = ElasticsearchAssertions.tryCreateNewInstance(streamable);
            if (newInstance == null) {
                return;
            }
            if (streamable instanceof ActionRequest) {
                ((ActionRequest)streamable).validate();
            }
            BytesReference orig = ElasticsearchAssertions.serialize(version, streamable);
            StreamInput input = StreamInput.wrap((BytesReference)orig);
            input.setVersion(version);
            newInstance.readFrom(input);
            MatcherAssert.assertThat((String)("Stream should be fully read with version [" + version + "] for streamable [" + streamable + "]"), (Object)input.available(), (Matcher)CoreMatchers.equalTo((Object)0));
            MatcherAssert.assertThat((String)("Serialization failed with version [" + version + "] bytes should be equal for streamable [" + streamable + "]"), (Object)ElasticsearchAssertions.serialize(version, streamable), (Matcher)CoreMatchers.equalTo((Object)orig));
        }
        catch (Throwable ex) {
            throw new RuntimeException("failed to check serialization - version [" + version + "] for streamable [" + streamable + "]", ex);
        }
    }

    public static void assertVersionSerializable(Version version, Throwable t) {
        ElasticsearchAssertions.assertVersionSerializable(version, new ThrowableWrapper(t));
    }

    private static Streamable tryCreateNewInstance(Streamable streamable) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        try {
            Class<?> clazz = streamable.getClass();
            Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
            MatcherAssert.assertThat(constructor, (Matcher)Matchers.notNullValue());
            Streamable newInstance = (Streamable)constructor.newInstance(new Object[0]);
            return newInstance;
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static SearchResponse assertSearchResponse(SearchRequestBuilder request) {
        return ElasticsearchAssertions.assertSearchResponse((SearchResponse)request.get());
    }

    public static SearchResponse assertSearchResponse(SearchResponse response) {
        ElasticsearchAssertions.assertNoFailures(response);
        return response;
    }

    public static void assertNodeContainsPlugins(NodesInfoResponse response, String nodeId, List<String> expectedJvmPluginNames, List<String> expectedJvmPluginDescriptions, List<String> expectedJvmVersions, List<String> expectedSitePluginNames, List<String> expectedSitePluginDescriptions, List<String> expectedSiteVersions) {
        Assert.assertThat(response.getNodesMap().get(nodeId), (Matcher)Matchers.notNullValue());
        PluginsAndModules plugins = ((NodeInfo)response.getNodesMap().get(nodeId)).getPlugins();
        Assert.assertThat((Object)plugins, (Matcher)Matchers.notNullValue());
        ImmutableList pluginNames = FluentIterable.from((Iterable)plugins.getPluginInfos()).filter(jvmPluginPredicate).transform(nameFunction).toList();
        for (String string : expectedJvmPluginNames) {
            Assert.assertThat((Object)pluginNames, (Matcher)Matchers.hasItem((Object)string));
        }
        ImmutableList pluginDescriptions = FluentIterable.from((Iterable)plugins.getPluginInfos()).filter(jvmPluginPredicate).transform(descriptionFunction).toList();
        for (String string : expectedJvmPluginDescriptions) {
            Assert.assertThat((Object)pluginDescriptions, (Matcher)Matchers.hasItem((Object)string));
        }
        ImmutableList immutableList = FluentIterable.from((Iterable)plugins.getPluginInfos()).filter(jvmPluginPredicate).transform(versionFunction).toList();
        for (String pluginVersion : expectedJvmVersions) {
            Assert.assertThat((Object)immutableList, (Matcher)Matchers.hasItem((Object)pluginVersion));
        }
        FluentIterable fluentIterable = FluentIterable.from((Iterable)plugins.getPluginInfos()).filter(Predicates.and(jvmPluginPredicate, (Predicate)Predicates.not(sitePluginPredicate))).transform(urlFunction).filter(Predicates.notNull());
        Assert.assertThat((Object)Iterables.size((Iterable)fluentIterable), (Matcher)CoreMatchers.is((Object)0));
        ImmutableList sitePluginNames = FluentIterable.from((Iterable)plugins.getPluginInfos()).filter(sitePluginPredicate).transform(nameFunction).toList();
        Assert.assertThat((Object)sitePluginNames.isEmpty(), (Matcher)CoreMatchers.is((Object)expectedSitePluginNames.isEmpty()));
        for (String string : expectedSitePluginNames) {
            Assert.assertThat((Object)sitePluginNames, (Matcher)Matchers.hasItem((Object)string));
        }
        ImmutableList sitePluginDescriptions = FluentIterable.from((Iterable)plugins.getPluginInfos()).filter(sitePluginPredicate).transform(descriptionFunction).toList();
        Assert.assertThat((Object)sitePluginDescriptions.isEmpty(), (Matcher)CoreMatchers.is((Object)expectedSitePluginDescriptions.isEmpty()));
        for (String sitePluginDescription : expectedSitePluginDescriptions) {
            Assert.assertThat((Object)sitePluginDescriptions, (Matcher)Matchers.hasItem((Object)sitePluginDescription));
        }
        ImmutableList immutableList2 = FluentIterable.from((Iterable)plugins.getPluginInfos()).filter(sitePluginPredicate).transform(urlFunction).toList();
        Assert.assertThat((Object)immutableList2, (Matcher)Matchers.not((Matcher)Matchers.contains((Matcher)Matchers.nullValue())));
        ImmutableList sitePluginVersions = FluentIterable.from((Iterable)plugins.getPluginInfos()).filter(sitePluginPredicate).transform(versionFunction).toList();
        Assert.assertThat((Object)sitePluginVersions.isEmpty(), (Matcher)CoreMatchers.is((Object)expectedSiteVersions.isEmpty()));
        for (String pluginVersion : expectedSiteVersions) {
            Assert.assertThat((Object)sitePluginVersions, (Matcher)Matchers.hasItem((Object)pluginVersion));
        }
    }

    public static void assertFileExists(Path file) {
        MatcherAssert.assertThat((String)("file/dir [" + file + "] should exist."), (Object)Files.exists(file, new LinkOption[0]), (Matcher)CoreMatchers.is((Object)true));
    }

    public static void assertFileNotExists(Path file) {
        MatcherAssert.assertThat((String)("file/dir [" + file + "] should not exist."), (Object)Files.exists(file, new LinkOption[0]), (Matcher)CoreMatchers.is((Object)false));
    }

    public static void assertDirectoryExists(Path dir) {
        ElasticsearchAssertions.assertFileExists(dir);
        MatcherAssert.assertThat((String)("file [" + dir + "] should be a directory."), (Object)Files.isDirectory(dir, new LinkOption[0]), (Matcher)CoreMatchers.is((Object)true));
    }

    public static final class ThrowableWrapper
    implements Streamable {
        Throwable throwable;

        public ThrowableWrapper(Throwable t) {
            this.throwable = t;
        }

        public ThrowableWrapper() {
            this.throwable = null;
        }

        public void readFrom(StreamInput in) throws IOException {
            this.throwable = in.readThrowable();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeThrowable(this.throwable);
        }
    }
}

