/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.hamcrest;

import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.ShapeCollection;
import com.spatial4j.core.shape.impl.GeoCircle;
import com.spatial4j.core.shape.impl.RectangleImpl;
import com.spatial4j.core.shape.jts.JtsGeometry;
import com.spatial4j.core.shape.jts.JtsPoint;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.common.geo.GeoDistance;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.builders.ShapeBuilder;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.common.xcontent.XContentParser;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class ElasticsearchGeoAssertions {
    private static int top(Coordinate ... points) {
        int top = 0;
        for (int i = 1; i < points.length; ++i) {
            if (points[i].y < points[top].y) {
                top = i;
                continue;
            }
            if (points[i].y != points[top].y || !(points[i].x <= points[top].x)) continue;
            top = i;
        }
        return top;
    }

    private static int prev(int top, Coordinate ... points) {
        for (int i = 1; i < points.length; ++i) {
            int p = (top + points.length - i) % points.length;
            if (points[p].x == points[top].x && points[p].y == points[top].y) continue;
            return p;
        }
        return -1;
    }

    private static int next(int top, Coordinate ... points) {
        for (int i = 1; i < points.length; ++i) {
            int n = (top + i) % points.length;
            if (points[n].x == points[top].x && points[n].y == points[top].y) continue;
            return n;
        }
        return -1;
    }

    private static Coordinate[] fixedOrderedRing(List<Coordinate> coordinates, boolean direction) {
        return ElasticsearchGeoAssertions.fixedOrderedRing(coordinates.toArray(new Coordinate[coordinates.size()]), direction);
    }

    private static Coordinate[] fixedOrderedRing(Coordinate[] points, boolean direction) {
        boolean orientation;
        int top = ElasticsearchGeoAssertions.top(points);
        int next = ElasticsearchGeoAssertions.next(top, points);
        int prev = ElasticsearchGeoAssertions.prev(top, points);
        boolean bl = orientation = points[next].x < points[prev].x;
        if (orientation != direction) {
            List<Coordinate> asList = Arrays.asList(points);
            Collections.reverse(asList);
            return ElasticsearchGeoAssertions.fixedOrderedRing(asList, direction);
        }
        if (top > 0) {
            Coordinate[] aligned = new Coordinate[points.length];
            System.arraycopy(points, top, aligned, 0, points.length - top - 1);
            System.arraycopy(points, 0, aligned, points.length - top - 1, top);
            aligned[aligned.length - 1] = aligned[0];
            return aligned;
        }
        return points;
    }

    public static void assertEquals(Coordinate c1, Coordinate c2) {
        Assert.assertTrue((String)("expected coordinate " + c1 + " but found " + c2), (c1.x == c2.x && c1.y == c2.y ? 1 : 0) != 0);
    }

    private static boolean isRing(Coordinate[] c) {
        return c[0].x == c[c.length - 1].x && c[0].y == c[c.length - 1].y;
    }

    public static void assertEquals(Coordinate[] c1, Coordinate[] c2) {
        Assert.assertEquals((long)c1.length, (long)c2.length);
        if (ElasticsearchGeoAssertions.isRing(c1) && ElasticsearchGeoAssertions.isRing(c2)) {
            c1 = ElasticsearchGeoAssertions.fixedOrderedRing(c1, true);
            c2 = ElasticsearchGeoAssertions.fixedOrderedRing(c2, true);
        }
        for (int i = 0; i < c2.length; ++i) {
            ElasticsearchGeoAssertions.assertEquals(c1[i], c2[i]);
        }
    }

    public static void assertEquals(LineString l1, LineString l2) {
        ElasticsearchGeoAssertions.assertEquals(l1.getCoordinates(), l2.getCoordinates());
    }

    public static void assertEquals(MultiLineString l1, MultiLineString l2) {
        ElasticsearchGeoAssertions.assertEquals(l1.getCoordinates(), l2.getCoordinates());
    }

    public static void assertEquals(Polygon p1, Polygon p2) {
        Assert.assertEquals((long)p1.getNumInteriorRing(), (long)p2.getNumInteriorRing());
        ElasticsearchGeoAssertions.assertEquals(p1.getExteriorRing(), p2.getExteriorRing());
        for (int i = 0; i < p1.getNumInteriorRing(); ++i) {
            ElasticsearchGeoAssertions.assertEquals(p1.getInteriorRingN(i), p2.getInteriorRingN(i));
        }
    }

    public static void assertEquals(MultiPolygon p1, MultiPolygon p2) {
        Assert.assertEquals((long)p1.getNumGeometries(), (long)p2.getNumGeometries());
        for (int i = 0; i < p1.getNumGeometries(); ++i) {
            Geometry a = p1.getGeometryN(i);
            Geometry b = p2.getGeometryN(i);
            ElasticsearchGeoAssertions.assertEquals(a, b);
        }
    }

    public static void assertEquals(Geometry s1, Geometry s2) {
        if (s1 instanceof LineString && s2 instanceof LineString) {
            ElasticsearchGeoAssertions.assertEquals((LineString)s1, (LineString)s2);
        } else if (s1 instanceof Polygon && s2 instanceof Polygon) {
            ElasticsearchGeoAssertions.assertEquals((Polygon)s1, (Polygon)s2);
        } else if (s1 instanceof MultiPoint && s2 instanceof MultiPoint) {
            Assert.assertEquals((Object)s1, (Object)s2);
        } else if (s1 instanceof MultiPolygon && s2 instanceof MultiPolygon) {
            ElasticsearchGeoAssertions.assertEquals((MultiPolygon)s1, (MultiPolygon)s2);
        } else if (s1 instanceof MultiLineString && s2 instanceof MultiLineString) {
            ElasticsearchGeoAssertions.assertEquals((MultiLineString)s1, (MultiLineString)s2);
        } else {
            throw new RuntimeException("equality of shape types not supported [" + s1.getClass().getName() + " and " + s2.getClass().getName() + "]");
        }
    }

    public static void assertEquals(JtsGeometry g1, JtsGeometry g2) {
        ElasticsearchGeoAssertions.assertEquals(g1.getGeom(), g2.getGeom());
    }

    public static void assertEquals(ShapeCollection s1, ShapeCollection s2) {
        Assert.assertEquals((long)s1.size(), (long)s2.size());
        for (int i = 0; i < s1.size(); ++i) {
            ElasticsearchGeoAssertions.assertEquals(s1.get(i), s2.get(i));
        }
    }

    public static void assertEquals(Shape s1, Shape s2) {
        if (s1 instanceof JtsGeometry && s2 instanceof JtsGeometry) {
            ElasticsearchGeoAssertions.assertEquals((JtsGeometry)s1, (JtsGeometry)s2);
        } else if (s1 instanceof JtsPoint && s2 instanceof JtsPoint) {
            JtsPoint p1 = (JtsPoint)s1;
            JtsPoint p2 = (JtsPoint)s2;
            Assert.assertEquals((Object)p1, (Object)p2);
        } else if (s1 instanceof ShapeCollection && s2 instanceof ShapeCollection) {
            ElasticsearchGeoAssertions.assertEquals((ShapeCollection)s1, (ShapeCollection)s2);
        } else if (s1 instanceof GeoCircle && s2 instanceof GeoCircle) {
            Assert.assertEquals((Object)((GeoCircle)s1), (Object)((GeoCircle)s2));
        } else if (s1 instanceof RectangleImpl && s2 instanceof RectangleImpl) {
            Assert.assertEquals((Object)((RectangleImpl)s1), (Object)((RectangleImpl)s2));
        } else {
            throw new RuntimeException("equality of shape types not supported [" + s1.getClass().getName() + " and " + s2.getClass().getName() + "]");
        }
    }

    private static Geometry unwrap(Shape shape) {
        Assert.assertThat((Object)shape, (Matcher)Matchers.instanceOf(JtsGeometry.class));
        return ((JtsGeometry)shape).getGeom();
    }

    public static void assertMultiPolygon(Shape shape) {
        assert (ElasticsearchGeoAssertions.unwrap(shape) instanceof MultiPolygon) : "expected MultiPolygon but found " + ElasticsearchGeoAssertions.unwrap(shape).getClass().getName();
    }

    public static void assertPolygon(Shape shape) {
        assert (ElasticsearchGeoAssertions.unwrap(shape) instanceof Polygon) : "expected Polygon but found " + ElasticsearchGeoAssertions.unwrap(shape).getClass().getName();
    }

    public static void assertLineString(Shape shape) {
        assert (ElasticsearchGeoAssertions.unwrap(shape) instanceof LineString) : "expected LineString but found " + ElasticsearchGeoAssertions.unwrap(shape).getClass().getName();
    }

    public static void assertMultiLineString(Shape shape) {
        assert (ElasticsearchGeoAssertions.unwrap(shape) instanceof MultiLineString) : "expected MultiLineString but found " + ElasticsearchGeoAssertions.unwrap(shape).getClass().getName();
    }

    public static void assertDistance(String geohash1, String geohash2, Matcher<Double> match) {
        GeoPoint p1 = new GeoPoint(geohash1);
        GeoPoint p2 = new GeoPoint(geohash2);
        ElasticsearchGeoAssertions.assertDistance(p1.lat(), p1.lon(), p2.lat(), p2.lon(), match);
    }

    public static void assertDistance(double lat1, double lon1, double lat2, double lon2, Matcher<Double> match) {
        Assert.assertThat((Object)ElasticsearchGeoAssertions.distance(lat1, lon1, lat2, lon2), match);
    }

    private static double distance(double lat1, double lon1, double lat2, double lon2) {
        return GeoDistance.ARC.calculate(lat1, lon1, lat2, lon2, DistanceUnit.DEFAULT);
    }

    public static void assertValidException(XContentParser parser, Class expectedException) {
        block2: {
            try {
                ShapeBuilder.parse((XContentParser)parser).build();
                Assert.fail((String)("process completed successfully when " + expectedException.getName() + " expected"));
            }
            catch (Exception e) {
                if ($assertionsDisabled || e.getClass().equals(expectedException)) break block2;
                throw new AssertionError((Object)("expected " + expectedException.getName() + " but found " + e.getClass().getName()));
            }
        }
    }
}

