/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.hamcrest;

import java.util.regex.Pattern;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class RegexMatcher
extends TypeSafeMatcher<String> {
    private final String regex;
    private final Pattern pattern;

    public RegexMatcher(String regex) {
        this.regex = regex;
        this.pattern = Pattern.compile(regex);
    }

    public RegexMatcher(String regex, int flag) {
        this.regex = regex;
        this.pattern = Pattern.compile(regex, flag);
    }

    protected boolean matchesSafely(String item) {
        return this.pattern.matcher(item).find();
    }

    public void describeTo(Description description) {
        description.appendText(this.regex);
    }

    public static RegexMatcher matches(String regex) {
        return new RegexMatcher(regex);
    }

    public static RegexMatcher matches(String regex, int flag) {
        return new RegexMatcher(regex, flag);
    }
}

