/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.junit.listeners;

import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.test.junit.annotations.TestLogging;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.RunListener;

public class LoggingListener
extends RunListener {
    private Map<String, String> previousLoggingMap;
    private Map<String, String> previousClassLoggingMap;
    private Map<String, String> previousPackageLoggingMap;

    public void testRunStarted(Description description) throws Exception {
        this.previousPackageLoggingMap = this.processTestLogging(description.getTestClass().getPackage().getAnnotation(TestLogging.class));
        this.previousClassLoggingMap = this.processTestLogging((TestLogging)description.getAnnotation(TestLogging.class));
    }

    public void testRunFinished(Result result) throws Exception {
        this.previousClassLoggingMap = this.reset(this.previousClassLoggingMap);
        this.previousPackageLoggingMap = this.reset(this.previousPackageLoggingMap);
    }

    public void testStarted(Description description) throws Exception {
        TestLogging testLogging = (TestLogging)description.getAnnotation(TestLogging.class);
        this.previousLoggingMap = this.processTestLogging(testLogging);
    }

    public void testFinished(Description description) throws Exception {
        this.previousLoggingMap = this.reset(this.previousLoggingMap);
    }

    private static ESLogger resolveLogger(String loggerName) {
        if (loggerName.equalsIgnoreCase("_root")) {
            return ESLoggerFactory.getRootLogger();
        }
        return Loggers.getLogger((String)loggerName);
    }

    private Map<String, String> processTestLogging(TestLogging testLogging) {
        Map<String, String> map = LoggingListener.getLoggersAndLevelsFromAnnotation(testLogging);
        if (map == null) {
            return null;
        }
        HashMap<String, String> previousValues = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            ESLogger esLogger = LoggingListener.resolveLogger(entry.getKey());
            previousValues.put(entry.getKey(), esLogger.getLevel());
            esLogger.setLevel(entry.getValue());
        }
        return previousValues;
    }

    public static Map<String, String> getLoggersAndLevelsFromAnnotation(TestLogging testLogging) {
        String[] loggersAndLevels;
        if (testLogging == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (String loggerAndLevel : loggersAndLevels = testLogging.value().split(",")) {
            String[] loggerAndLevelArray = loggerAndLevel.split(":");
            if (loggerAndLevelArray.length < 2) continue;
            String loggerName = loggerAndLevelArray[0];
            String level = loggerAndLevelArray[1];
            map.put(loggerName, level);
        }
        return map;
    }

    private Map<String, String> reset(Map<String, String> map) {
        if (map != null) {
            for (Map.Entry<String, String> previousLogger : map.entrySet()) {
                ESLogger esLogger = LoggingListener.resolveLogger(previousLogger.getKey());
                esLogger.setLevel(previousLogger.getValue());
            }
        }
        return null;
    }
}

