/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.junit.listeners;

import com.carrotsearch.randomizedtesting.RandomizedContext;
import com.carrotsearch.randomizedtesting.ReproduceErrorMessageBuilder;
import com.carrotsearch.randomizedtesting.SysGlobals;
import com.carrotsearch.randomizedtesting.TraceFormatting;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.test.ESTestCase;
import org.junit.internal.AssumptionViolatedException;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class ReproduceInfoPrinter
extends RunListener {
    protected final ESLogger logger = Loggers.getLogger(ESTestCase.class);

    public void testStarted(Description description) throws Exception {
        this.logger.trace("Test {} started", new Object[]{description.getDisplayName()});
    }

    public void testFinished(Description description) throws Exception {
        this.logger.trace("Test {} finished", new Object[]{description.getDisplayName()});
    }

    static boolean inVerifyPhase() {
        return Boolean.parseBoolean(System.getProperty("tests.verify.phase"));
    }

    public void testFailure(Failure failure) throws Exception {
        if (failure.getException() instanceof AssumptionViolatedException) {
            return;
        }
        StringBuilder b = new StringBuilder();
        if (ReproduceInfoPrinter.inVerifyPhase()) {
            b.append("REPRODUCE WITH: mvn verify -Pdev -Dskip.unit.tests");
        } else {
            b.append("REPRODUCE WITH: mvn test -Pdev");
        }
        String project = System.getProperty("tests.project");
        if (project != null) {
            b.append(" -pl " + project);
        }
        MavenMessageBuilder mavenMessageBuilder = new MavenMessageBuilder(b);
        mavenMessageBuilder.appendAllOpts(failure.getDescription());
        System.err.println(b.toString());
    }

    protected TraceFormatting traces() {
        TraceFormatting traces = new TraceFormatting();
        try {
            traces = RandomizedContext.current().getRunner().getTraceFormatting();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return traces;
    }

    protected static class MavenMessageBuilder
    extends ReproduceErrorMessageBuilder {
        public MavenMessageBuilder(StringBuilder b) {
            super(b);
        }

        public ReproduceErrorMessageBuilder appendAllOpts(Description description) {
            super.appendAllOpts(description);
            if (description.getMethodName() != null) {
                super.appendOpt(SysGlobals.SYSPROP_TESTMETHOD(), "\"" + description.getMethodName() + "\"");
            }
            ArrayList<String> properties = new ArrayList<String>();
            this.scanProperties(description.getTestClass(), properties);
            this.appendProperties(properties.toArray(new String[properties.size()]));
            return this.appendESProperties();
        }

        private void scanProperties(Class<?> c, List<String> properties) {
            Properties extraParameterAnnocation;
            if (!Object.class.equals(c)) {
                this.scanProperties(c.getSuperclass(), properties);
            }
            if ((extraParameterAnnocation = c.getAnnotation(Properties.class)) != null) {
                for (String property : extraParameterAnnocation.value()) {
                    properties.add(property);
                }
            }
        }

        public ReproduceErrorMessageBuilder appendEnvironmentSettings() {
            return this;
        }

        public ReproduceErrorMessageBuilder appendOpt(String sysPropName, String value) {
            if (sysPropName.equals(SysGlobals.SYSPROP_ITERATIONS())) {
                return this;
            }
            if (sysPropName.equals(SysGlobals.SYSPROP_TESTMETHOD())) {
                return this;
            }
            if (sysPropName.equals(SysGlobals.SYSPROP_PREFIX())) {
                return this;
            }
            if (Strings.hasLength((String)value)) {
                if (value.indexOf(32) >= 0) {
                    return super.appendOpt(sysPropName, '\"' + value + '\"');
                }
                return super.appendOpt(sysPropName, value);
            }
            return this;
        }

        public ReproduceErrorMessageBuilder appendESProperties() {
            if (System.getProperty("tests.jvm.argline") != null && !System.getProperty("tests.jvm.argline").isEmpty()) {
                this.appendOpt("tests.jvm.argline", System.getProperty("tests.jvm.argline"));
            }
            this.appendOpt("tests.locale", Locale.getDefault().toLanguageTag());
            this.appendOpt("tests.timezone", TimeZone.getDefault().getID());
            return this;
        }

        protected ReproduceErrorMessageBuilder appendProperties(String ... properties) {
            for (String sysPropName : properties) {
                if (!Strings.hasLength((String)System.getProperty(sysPropName))) continue;
                this.appendOpt(sysPropName, System.getProperty(sysPropName));
            }
            return this;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Properties {
        public String[] value();
    }
}

