/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.junit.rule;

import org.elasticsearch.common.logging.ESLogger;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class RepeatOnExceptionRule
implements TestRule {
    private ESLogger logger;
    private int retryCount;
    private Class expectedException;

    public RepeatOnExceptionRule(ESLogger logger, int retryCount, Class expectedException) {
        this.logger = logger;
        this.retryCount = retryCount;
        this.expectedException = expectedException;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                Throwable caughtThrowable = null;
                for (int i = 0; i < RepeatOnExceptionRule.this.retryCount; ++i) {
                    try {
                        base.evaluate();
                        return;
                    }
                    catch (Throwable t) {
                        if (!t.getClass().equals(RepeatOnExceptionRule.this.expectedException)) {
                            throw t;
                        }
                        caughtThrowable = t;
                        RepeatOnExceptionRule.this.logger.info("Exception [{}] occurred, rerunning the test after [{}] failures", t, new Object[]{t.getClass().getSimpleName(), i + 1});
                        continue;
                    }
                }
                RepeatOnExceptionRule.this.logger.error("Giving up after [{}] failures... marking test as failed", new Object[]{RepeatOnExceptionRule.this.retryCount});
                throw caughtThrowable;
            }
        };
    }
}

