/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest;

import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.rest.BlacklistedPathPatternMatcher;

public class BlacklistedPathPatternMatcherTests
extends ESTestCase {
    public void testMatchesExact() {
        this.assertMatch("cat.aliases/10_basic/Empty cluster", "/some/suite_path/cat.aliases/10_basic/Empty cluster");
        this.assertMatch("cat.aliases/10_basic/Empty cluster", "cat.aliases/10_basic/Empty cluster");
        this.assertNoMatch("cat.aliases/10_basic/Empty cluster", "cat.aliases/10_basic/Empty clusters in here");
    }

    public void testMatchesSimpleWildcardPatterns() {
        this.assertMatch("termvector/20_issue7121/*", "/suite/termvector/20_issue7121/test_first");
        this.assertMatch("termvector/20_issue7121/*", "/suite/termvector/20_issue7121/");
        this.assertNoMatch("termvector/20_issue7121/*", "/suite/termvector/20_issue7121/test/first");
    }

    public void testMatchesMultiWildcardPatterns() {
        this.assertMatch("indices.get/10_basic/*allow_no_indices*", "/suite/indices.get/10_basic/we_allow_no_indices");
        this.assertMatch("indices.get/10_basic/*allow_no_indices*", "/suite/indices.get/10_basic/we_allow_no_indices_at_all");
        this.assertNoMatch("indices.get/10_basic/*allow_no_indices*", "/suite/indices.get/10_basic/we_allow_no_indices_at_all/here");
        this.assertMatch("indices.get/*/*allow_no_indices*", "/suite/indices.get/10_basic/we_allow_no_indices_at_all");
        this.assertMatch("indices.get/*/*allow_no_indices*", "/suite/indices.get/20_basic/we_allow_no_indices_at_all");
        this.assertMatch("*/*/*allow_no_indices*", "/suite/path/to/test/indices.get/20_basic/we_allow_no_indices_at_all");
    }

    public void testMatchesPatternsWithEscapedCommas() {
        this.assertMatch("indices.get/10_basic\\,20_advanced/foo", "/suite/indices.get/10_basic,20_advanced/foo");
    }

    public void testMatchesMixedPatterns() {
        this.assertMatch("indices.get/*/10_basic\\,20_advanced/*foo*", "/suite/indices.get/all/10_basic,20_advanced/foo");
        this.assertMatch("indices.get/*/10_basic\\,20_advanced/*foo*", "/suite/indices.get/all/10_basic,20_advanced/my_foo");
        this.assertMatch("indices.get/*/10_basic\\,20_advanced/*foo*", "/suite/indices.get/all/10_basic,20_advanced/foo_bar");
    }

    private void assertMatch(String pattern, String path) {
        BlacklistedPathPatternMatcher matcher = new BlacklistedPathPatternMatcher(pattern);
        BlacklistedPathPatternMatcherTests.assertTrue((String)("Pattern [" + pattern + "] should have matched path [" + path + "]"), (boolean)matcher.isSuffixMatch(path));
    }

    private void assertNoMatch(String pattern, String path) {
        BlacklistedPathPatternMatcher matcher = new BlacklistedPathPatternMatcher(pattern);
        BlacklistedPathPatternMatcherTests.assertFalse((String)("Pattern [" + pattern + "] should not have matched path [" + path + "]"), (boolean)matcher.isSuffixMatch(path));
    }
}

