/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest;

import com.carrotsearch.randomizedtesting.RandomizedTest;
import com.carrotsearch.randomizedtesting.annotations.TestGroup;
import com.carrotsearch.randomizedtesting.annotations.TimeoutSuite;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.LuceneTestCase;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.test.ESIntegTestCase;
import org.elasticsearch.test.junit.listeners.ReproduceInfoPrinter;
import org.elasticsearch.test.rest.BlacklistedPathPatternMatcher;
import org.elasticsearch.test.rest.RestTestCandidate;
import org.elasticsearch.test.rest.RestTestExecutionContext;
import org.elasticsearch.test.rest.client.RestException;
import org.elasticsearch.test.rest.parser.RestTestParseException;
import org.elasticsearch.test.rest.parser.RestTestSuiteParser;
import org.elasticsearch.test.rest.section.DoSection;
import org.elasticsearch.test.rest.section.ExecutableSection;
import org.elasticsearch.test.rest.section.RestTestSuite;
import org.elasticsearch.test.rest.section.SkipSection;
import org.elasticsearch.test.rest.section.TestSection;
import org.elasticsearch.test.rest.spec.RestApi;
import org.elasticsearch.test.rest.spec.RestSpec;
import org.elasticsearch.test.rest.support.FileUtils;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

@Rest
@LuceneTestCase.SuppressFsync
@LuceneTestCase.SuppressCodecs(value={"*"})
@ESIntegTestCase.ClusterScope(randomDynamicTemplates=false)
@TimeoutSuite(millis=2400000)
@ReproduceInfoPrinter.Properties(value={"tests.rest.suite", "tests.rest.spec", "tests.rest.blacklist"})
public abstract class ESRestTestCase
extends ESIntegTestCase {
    public static final String TESTS_REST = "tests.rest";
    public static final String REST_TESTS_SUITE = "tests.rest.suite";
    public static final String REST_TESTS_BLACKLIST = "tests.rest.blacklist";
    public static final String REST_TESTS_VALIDATE_SPEC = "tests.rest.validate_spec";
    public static final String REST_TESTS_SPEC = "tests.rest.spec";
    public static final String REST_LOAD_PACKAGED_TESTS = "tests.rest.load_packaged";
    private static final String DEFAULT_TESTS_PATH = "/rest-api-spec/test";
    private static final String DEFAULT_SPEC_PATH = "/rest-api-spec/api";
    private static final String PATHS_SEPARATOR = "(?<!\\\\),";
    private final List<BlacklistedPathPatternMatcher> blacklistPathMatchers = new ArrayList<BlacklistedPathPatternMatcher>();
    private static RestTestExecutionContext restTestExecutionContext;
    private final RestTestCandidate testCandidate;

    public ESRestTestCase(RestTestCandidate testCandidate) {
        String[] blacklist;
        this.testCandidate = testCandidate;
        for (String entry : blacklist = ESRestTestCase.resolvePathsProperty(REST_TESTS_BLACKLIST, null)) {
            this.blacklistPathMatchers.add(new BlacklistedPathPatternMatcher(entry));
        }
    }

    @Override
    protected void afterIfFailed(List<Throwable> errors) {
        this.logger.info("Stash dump on failure [{}]", new Object[]{XContentHelper.toString((ToXContent)restTestExecutionContext.stash())});
        super.afterIfFailed(errors);
    }

    @Override
    protected Settings nodeSettings(int nodeOrdinal) {
        return Settings.builder().putArray("repositories.url.allowed_urls", new String[]{"http://snapshot.test*"}).put("http.enabled", true).put("node.testattr", "test").put(super.nodeSettings(nodeOrdinal)).build();
    }

    public static Iterable<Object[]> createParameters(int id, int count) throws IOException, RestTestParseException {
        boolean enabled;
        TestGroup testGroup = Rest.class.getAnnotation(TestGroup.class);
        String sysProperty = TestGroup.Utilities.getSysProperty(Rest.class);
        try {
            enabled = RandomizedTest.systemPropertyAsBoolean((String)sysProperty, (boolean)testGroup.enabled());
        }
        catch (IllegalArgumentException e) {
            enabled = false;
        }
        if (!enabled) {
            return new ArrayList<Object[]>();
        }
        List<RestTestCandidate> restTestCandidates = ESRestTestCase.collectTestCandidates(id, count);
        ArrayList<Object[]> objects = new ArrayList<Object[]>();
        for (RestTestCandidate restTestCandidate : restTestCandidates) {
            objects.add(new Object[]{restTestCandidate});
        }
        return objects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<RestTestCandidate> collectTestCandidates(int id, int count) throws RestTestParseException, IOException {
        ArrayList<RestTestCandidate> testCandidates = new ArrayList<RestTestCandidate>();
        FileSystem fileSystem = ESRestTestCase.getFileSystem();
        try {
            String[] paths = ESRestTestCase.resolvePathsProperty(REST_TESTS_SUITE, DEFAULT_TESTS_PATH);
            Map<String, Set<Path>> yamlSuites = FileUtils.findYamlSuites(fileSystem, DEFAULT_TESTS_PATH, paths);
            RestTestSuiteParser restTestSuiteParser = new RestTestSuiteParser();
            for (String api : yamlSuites.keySet()) {
                ArrayList yamlFiles = new ArrayList(yamlSuites.get(api));
                for (Path yamlFile : yamlFiles) {
                    String key = api + yamlFile.getFileName().toString();
                    if (!ESRestTestCase.mustExecute(key, id, count)) continue;
                    RestTestSuite restTestSuite = restTestSuiteParser.parse(api, yamlFile);
                    for (TestSection testSection : restTestSuite.getTestSections()) {
                        testCandidates.add(new RestTestCandidate(restTestSuite, testSection));
                    }
                }
            }
        }
        catch (Throwable throwable) {
            IOUtils.close((Closeable[])new Closeable[]{fileSystem});
            throw throwable;
        }
        IOUtils.close((Closeable[])new Closeable[]{fileSystem});
        Collections.sort(testCandidates, new Comparator<RestTestCandidate>(){

            @Override
            public int compare(RestTestCandidate o1, RestTestCandidate o2) {
                return o1.getTestPath().compareTo(o2.getTestPath());
            }
        });
        return testCandidates;
    }

    private static boolean mustExecute(String test, int id, int count) {
        int hash = (int)(Math.abs((long)test.hashCode()) % (long)count);
        return hash == id;
    }

    private static String[] resolvePathsProperty(String propertyName, String defaultValue) {
        String property = System.getProperty(propertyName);
        if (!Strings.hasLength((String)property)) {
            String[] stringArray;
            if (defaultValue == null) {
                stringArray = Strings.EMPTY_ARRAY;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = defaultValue;
            }
            return stringArray;
        }
        return property.split(PATHS_SEPARATOR);
    }

    @SuppressForbidden(reason="proper use of URL, hack around a JDK bug")
    static FileSystem getFileSystem() throws IOException {
        URL codeLocation = FileUtils.class.getProtectionDomain().getCodeSource().getLocation();
        boolean loadPackaged = RandomizedTest.systemPropertyAsBoolean((String)REST_LOAD_PACKAGED_TESTS, (boolean)true);
        if (codeLocation.getFile().endsWith(".jar") && loadPackaged) {
            try {
                Path tmp = Files.createTempFile(null, ".jar", new FileAttribute[0]);
                try (InputStream in = codeLocation.openStream();){
                    Files.copy(in, tmp, StandardCopyOption.REPLACE_EXISTING);
                }
                return FileSystems.newFileSystem(new URI("jar:" + tmp.toUri()), Collections.emptyMap());
            }
            catch (URISyntaxException e) {
                throw new IOException("couldn't open zipfilesystem: ", e);
            }
        }
        return null;
    }

    @BeforeClass
    public static void initExecutionContext() throws IOException, RestException {
        String[] specPaths = ESRestTestCase.resolvePathsProperty(REST_TESTS_SPEC, DEFAULT_SPEC_PATH);
        RestSpec restSpec = null;
        FileSystem fileSystem = ESRestTestCase.getFileSystem();
        try {
            restSpec = RestSpec.parseFrom(fileSystem, DEFAULT_SPEC_PATH, specPaths);
        }
        catch (Throwable throwable) {
            IOUtils.close((Closeable[])new Closeable[]{fileSystem});
            throw throwable;
        }
        IOUtils.close((Closeable[])new Closeable[]{fileSystem});
        ESRestTestCase.validateSpec(restSpec);
        restTestExecutionContext = new RestTestExecutionContext(restSpec);
    }

    private static void validateSpec(RestSpec restSpec) {
        boolean validateSpec = RandomizedTest.systemPropertyAsBoolean((String)REST_TESTS_VALIDATE_SPEC, (boolean)true);
        if (validateSpec) {
            StringBuilder errorMessage = new StringBuilder();
            for (RestApi restApi : restSpec.getApis()) {
                if (!restApi.getMethods().contains("GET") || !restApi.isBodySupported() || restApi.getMethods().contains("POST")) continue;
                errorMessage.append("\n- ").append(restApi.getName()).append(" supports GET with a body but doesn't support POST");
            }
            if (errorMessage.length() > 0) {
                throw new IllegalArgumentException(errorMessage.toString());
            }
        }
    }

    @AfterClass
    public static void close() {
        if (restTestExecutionContext != null) {
            restTestExecutionContext.close();
            restTestExecutionContext = null;
        }
    }

    @Override
    protected int maximumNumberOfShards() {
        return 3;
    }

    @Override
    protected int maximumNumberOfReplicas() {
        return 1;
    }

    protected Settings restClientSettings() {
        return Settings.EMPTY;
    }

    @Before
    public void reset() throws IOException, RestException {
        for (BlacklistedPathPatternMatcher blacklistedPathMatcher : this.blacklistPathMatchers) {
            String testPath = this.testCandidate.getSuitePath() + "/" + this.testCandidate.getTestSection().getName();
            ESRestTestCase.assumeFalse((String)("[" + this.testCandidate.getTestPath() + "] skipped, reason: blacklisted"), (boolean)blacklistedPathMatcher.isSuffixMatch(testPath));
        }
        restTestExecutionContext.initClient(ESRestTestCase.cluster().httpAddresses(), this.restClientSettings());
        restTestExecutionContext.clear();
        ESRestTestCase.assumeFalse((String)ESRestTestCase.buildSkipMessage(this.testCandidate.getSuitePath(), this.testCandidate.getSetupSection().getSkipSection()), (boolean)this.testCandidate.getSetupSection().getSkipSection().skip(restTestExecutionContext.esVersion()));
        ESRestTestCase.assumeFalse((String)ESRestTestCase.buildSkipMessage(this.testCandidate.getTestPath(), this.testCandidate.getTestSection().getSkipSection()), (boolean)this.testCandidate.getTestSection().getSkipSection().skip(restTestExecutionContext.esVersion()));
    }

    private static String buildSkipMessage(String description, SkipSection skipSection) {
        StringBuilder messageBuilder = new StringBuilder();
        if (skipSection.isVersionCheck()) {
            messageBuilder.append("[").append(description).append("] skipped, reason: [").append(skipSection.getReason()).append("] ");
        } else {
            messageBuilder.append("[").append(description).append("] skipped, reason: features ").append(skipSection.getFeatures()).append(" not supported");
        }
        return messageBuilder.toString();
    }

    @Test
    public void test() throws IOException {
        if (this.testCandidate.getTestSection().getExecutableSections().size() == 0) {
            throw new IllegalArgumentException("No executable sections loaded for [" + this.testCandidate.getTestPath() + "]");
        }
        if (!this.testCandidate.getSetupSection().isEmpty()) {
            this.logger.info("start setup test [{}]", new Object[]{this.testCandidate.getTestPath()});
            for (DoSection doSection : this.testCandidate.getSetupSection().getDoSections()) {
                doSection.execute(restTestExecutionContext);
            }
            this.logger.info("end setup test [{}]", new Object[]{this.testCandidate.getTestPath()});
        }
        restTestExecutionContext.clear();
        for (ExecutableSection executableSection : this.testCandidate.getTestSection().getExecutableSections()) {
            executableSection.execute(restTestExecutionContext);
        }
    }

    @Inherited
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @TestGroup(enabled=true, sysProperty="tests.rest")
    public static @interface Rest {
    }
}

