/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest;

import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.rest.RestRequest;

public class FakeRestRequest
extends RestRequest {
    private final Map<String, String> headers;
    private final Map<String, String> params;

    public FakeRestRequest() {
        this(new HashMap<String, String>(), new HashMap<String, String>());
    }

    public FakeRestRequest(Map<String, String> headers, Map<String, String> context) {
        this.headers = headers;
        for (Map.Entry<String, String> entry : context.entrySet()) {
            this.putInContext(entry.getKey(), entry.getValue());
        }
        this.params = new HashMap<String, String>();
    }

    public RestRequest.Method method() {
        return RestRequest.Method.GET;
    }

    public String uri() {
        return "/";
    }

    public String rawPath() {
        return "/";
    }

    public boolean hasContent() {
        return false;
    }

    public BytesReference content() {
        return null;
    }

    public String header(String name) {
        return this.headers.get(name);
    }

    public Iterable<Map.Entry<String, String>> headers() {
        return this.headers.entrySet();
    }

    public boolean hasParam(String key) {
        return this.params.containsKey(key);
    }

    public String param(String key) {
        return this.params.get(key);
    }

    public String param(String key, String defaultValue) {
        String value = this.params.get(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public Map<String, String> params() {
        return this.params;
    }
}

