/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest;

import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.Version;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.test.rest.Stash;
import org.elasticsearch.test.rest.client.RestClient;
import org.elasticsearch.test.rest.client.RestException;
import org.elasticsearch.test.rest.client.RestResponse;
import org.elasticsearch.test.rest.spec.RestSpec;

public class RestTestExecutionContext
implements Closeable {
    private static final ESLogger logger = Loggers.getLogger(RestTestExecutionContext.class);
    private final Stash stash = new Stash();
    private final RestSpec restSpec;
    private RestClient restClient;
    private RestResponse response;

    public RestTestExecutionContext(RestSpec restSpec) {
        this.restSpec = restSpec;
    }

    public RestResponse callApi(String apiName, Map<String, String> params, List<Map<String, Object>> bodies, Map<String, String> headers) throws IOException, RestException {
        HashMap requestParams = Maps.newHashMap(params);
        for (Map.Entry entry : requestParams.entrySet()) {
            if (!this.stash.isStashedValue(entry.getValue())) continue;
            entry.setValue(this.stash.unstashValue((String)entry.getValue()).toString());
        }
        String body = this.actualBody(bodies);
        try {
            this.response = this.callApiInternal(apiName, requestParams, body, headers);
            this.stash.stashValue("body", this.response.getBody());
            return this.response;
        }
        catch (RestException restException) {
            this.response = restException.restResponse();
            throw restException;
        }
    }

    private String actualBody(List<Map<String, Object>> bodies) throws IOException {
        if (bodies.isEmpty()) {
            return "";
        }
        if (bodies.size() == 1) {
            return this.bodyAsString(this.stash.unstashMap(bodies.get(0)));
        }
        StringBuilder bodyBuilder = new StringBuilder();
        for (Map<String, Object> body : bodies) {
            bodyBuilder.append(this.bodyAsString(this.stash.unstashMap(body))).append("\n");
        }
        return bodyBuilder.toString();
    }

    private String bodyAsString(Map<String, Object> body) throws IOException {
        return XContentFactory.jsonBuilder().map(body).string();
    }

    private RestResponse callApiInternal(String apiName, Map<String, String> params, String body, Map<String, String> headers) throws IOException, RestException {
        return this.restClient.callApi(apiName, params, body, headers);
    }

    public Object response(String path) throws IOException {
        return this.response.evaluate(path, this.stash);
    }

    public void initClient(InetSocketAddress[] addresses, Settings settings) throws IOException, RestException {
        if (this.restClient == null) {
            this.restClient = new RestClient(this.restSpec, settings, addresses);
        }
    }

    public void clear() {
        logger.debug("resetting client, response and stash", new Object[0]);
        this.response = null;
        this.stash.clear();
    }

    public Stash stash() {
        return this.stash;
    }

    public Version esVersion() {
        return this.restClient.getEsVersion();
    }

    @Override
    public void close() {
        if (this.restClient != null) {
            this.restClient.close();
        }
    }
}

