/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class Stash
implements ToXContent {
    private static final ESLogger logger = Loggers.getLogger(Stash.class);
    public static final Stash EMPTY = new Stash();
    private final Map<String, Object> stash = Maps.newHashMap();

    public void stashValue(String key, Object value) {
        logger.trace("stashing [{}]=[{}]", new Object[]{key, value});
        Object old = this.stash.put(key, value);
        if (old != null && old != value) {
            logger.trace("replaced stashed value [{}] with same key [{}]", new Object[]{old, key});
        }
    }

    public void clear() {
        this.stash.clear();
    }

    public boolean isStashedValue(Object key) {
        if (key == null) {
            return false;
        }
        String stashKey = key.toString();
        return Strings.hasLength((String)stashKey) && stashKey.startsWith("$");
    }

    public Object unstashValue(String value) {
        Object stashedValue = this.stash.get(value.substring(1));
        if (stashedValue == null) {
            throw new IllegalArgumentException("stashed value not found for key [" + value + "]");
        }
        return stashedValue;
    }

    public Map<String, Object> unstashMap(Map<String, Object> map) {
        HashMap copy = Maps.newHashMap(map);
        this.unstashObject(copy);
        return copy;
    }

    private void unstashObject(Object obj) {
        if (obj instanceof List) {
            List list = (List)obj;
            for (int i = 0; i < list.size(); ++i) {
                Object e = list.get(i);
                if (this.isStashedValue(e)) {
                    list.set(i, this.unstashValue(e.toString()));
                    continue;
                }
                this.unstashObject(e);
            }
        }
        if (obj instanceof Map) {
            Map map = (Map)obj;
            for (Map.Entry entry : map.entrySet()) {
                if (this.isStashedValue(entry.getValue())) {
                    entry.setValue(this.unstashValue(entry.getValue().toString()));
                    continue;
                }
                this.unstashObject(entry.getValue());
            }
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("stash", this.stash);
        return builder;
    }
}

