/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.client;

import java.io.IOException;
import org.elasticsearch.test.rest.Stash;
import org.elasticsearch.test.rest.client.http.HttpResponse;
import org.elasticsearch.test.rest.json.JsonPath;

public class RestResponse {
    private final HttpResponse response;
    private JsonPath parsedResponse;

    public RestResponse(HttpResponse response) {
        this.response = response;
    }

    public int getStatusCode() {
        return this.response.getStatusCode();
    }

    public String getReasonPhrase() {
        return this.response.getReasonPhrase();
    }

    public Object getBody() throws IOException {
        if (this.isJson()) {
            return this.parsedResponse().evaluate("");
        }
        return this.response.getBody();
    }

    public String getBodyAsString() {
        return this.response.getBody();
    }

    public boolean isError() {
        return this.response.isError();
    }

    public Object evaluate(String path) throws IOException {
        return this.evaluate(path, Stash.EMPTY);
    }

    public Object evaluate(String path, Stash stash) throws IOException {
        if (this.response == null) {
            return null;
        }
        JsonPath jsonPath = this.parsedResponse();
        if (jsonPath == null) {
            if ("".equals(path) && !this.response.supportsBody()) {
                return !this.response.isError();
            }
            return null;
        }
        return jsonPath.evaluate(path, stash);
    }

    private boolean isJson() {
        String contentType = this.response.getHeaders().get("Content-Type");
        return contentType != null && contentType.contains("application/json");
    }

    private JsonPath parsedResponse() throws IOException {
        if (this.parsedResponse != null) {
            return this.parsedResponse;
        }
        if (this.response == null || !this.response.hasBody()) {
            return null;
        }
        this.parsedResponse = new JsonPath(this.response.getBody());
        return this.parsedResponse;
    }
}

