/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.client.http;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.elasticsearch.client.support.Headers;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.test.rest.client.http.HttpDeleteWithEntity;
import org.elasticsearch.test.rest.client.http.HttpGetWithEntity;
import org.elasticsearch.test.rest.client.http.HttpResponse;

public class HttpRequestBuilder {
    private static final ESLogger logger = Loggers.getLogger(HttpRequestBuilder.class);
    static final Charset DEFAULT_CHARSET = Charset.forName("utf-8");
    private final CloseableHttpClient httpClient;
    private String protocol = "http";
    private String host;
    private int port;
    private String path = "";
    private final Map<String, String> params = Maps.newHashMap();
    private final Map<String, String> headers = Maps.newHashMap();
    private String method = "GET";
    private String body;

    public HttpRequestBuilder(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public HttpRequestBuilder host(String host) {
        this.host = host;
        return this;
    }

    public HttpRequestBuilder httpTransport(HttpServerTransport httpServerTransport) {
        InetSocketTransportAddress transportAddress = (InetSocketTransportAddress)httpServerTransport.boundAddress().publishAddress();
        return this.host(NetworkAddress.formatAddress((InetAddress)transportAddress.address().getAddress())).port(transportAddress.address().getPort());
    }

    public HttpRequestBuilder port(int port) {
        this.port = port;
        return this;
    }

    public HttpRequestBuilder path(String path) {
        this.path = path;
        return this;
    }

    public HttpRequestBuilder pathParts(String ... path) {
        if (path.length == 0) {
            this.path = "/";
            return this;
        }
        StringBuilder finalPath = new StringBuilder();
        for (String pathPart : path) {
            try {
                finalPath.append('/');
                URI uri = new URI(null, null, null, -1, "/" + pathPart, null, null);
                finalPath.append(uri.getRawPath().substring(1).replaceAll("/", "%2F"));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("unable to build uri", e);
            }
        }
        this.path = finalPath.toString();
        return this;
    }

    public HttpRequestBuilder addParam(String name, String value) {
        try {
            this.params.put(name, URLEncoder.encode(value, "utf-8"));
            return this;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public HttpRequestBuilder addHeaders(Headers headers) {
        for (String header : headers.headers().names()) {
            this.headers.put(header, headers.headers().get(header));
        }
        return this;
    }

    public HttpRequestBuilder addHeader(String name, String value) {
        this.headers.put(name, value);
        return this;
    }

    public HttpRequestBuilder protocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    public HttpRequestBuilder method(String method) {
        this.method = method;
        return this;
    }

    public HttpRequestBuilder body(String body) {
        if (Strings.hasLength((String)body)) {
            this.body = body;
        }
        return this;
    }

    public HttpResponse execute() throws IOException {
        HttpUriRequest httpUriRequest = this.buildRequest();
        if (logger.isTraceEnabled()) {
            StringBuilder stringBuilder = new StringBuilder(httpUriRequest.getMethod()).append(" ").append(httpUriRequest.getURI());
            if (Strings.hasLength((String)this.body)) {
                stringBuilder.append("\n").append(this.body);
            }
            logger.trace("sending request \n{}", new Object[]{stringBuilder.toString()});
        }
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            logger.trace("adding header [{} => {}]", new Object[]{entry.getKey(), entry.getValue()});
            httpUriRequest.addHeader(entry.getKey(), entry.getValue());
        }
        try (CloseableHttpResponse closeableHttpResponse = this.httpClient.execute(httpUriRequest);){
            HttpResponse httpResponse = new HttpResponse(httpUriRequest, closeableHttpResponse);
            logger.trace("got response \n{}\n{}", new Object[]{closeableHttpResponse, httpResponse.hasBody() ? httpResponse.getBody() : ""});
            HttpResponse httpResponse2 = httpResponse;
            return httpResponse2;
        }
    }

    private HttpUriRequest buildRequest() {
        if ("GET".equalsIgnoreCase(this.method)) {
            return this.addOptionalBody(new HttpGetWithEntity(this.buildUri()));
        }
        if ("HEAD".equalsIgnoreCase(this.method)) {
            this.checkBodyNotSupported();
            return new HttpHead(this.buildUri());
        }
        if ("OPTIONS".equalsIgnoreCase(this.method)) {
            this.checkBodyNotSupported();
            return new HttpOptions(this.buildUri());
        }
        if ("DELETE".equalsIgnoreCase(this.method)) {
            return this.addOptionalBody(new HttpDeleteWithEntity(this.buildUri()));
        }
        if ("PUT".equalsIgnoreCase(this.method)) {
            return this.addOptionalBody((HttpEntityEnclosingRequestBase)new HttpPut(this.buildUri()));
        }
        if ("POST".equalsIgnoreCase(this.method)) {
            return this.addOptionalBody((HttpEntityEnclosingRequestBase)new HttpPost(this.buildUri()));
        }
        throw new UnsupportedOperationException("method [" + this.method + "] not supported");
    }

    private URI buildUri() {
        StringBuilder uriBuilder = new StringBuilder(this.protocol).append("://").append(this.host).append(":").append(this.port).append(this.path);
        if (this.params.size() > 0) {
            uriBuilder.append("?").append(Joiner.on((char)'&').withKeyValueSeparator("=").join(this.params));
        }
        return URI.create(uriBuilder.toString());
    }

    private HttpEntityEnclosingRequestBase addOptionalBody(HttpEntityEnclosingRequestBase requestBase) {
        if (Strings.hasText((String)this.body)) {
            requestBase.setEntity((HttpEntity)new StringEntity(this.body, DEFAULT_CHARSET));
        }
        return requestBase;
    }

    private void checkBodyNotSupported() {
        if (Strings.hasText((String)this.body)) {
            throw new IllegalArgumentException("request body not supported with head request");
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.method).append(" '").append(this.host).append(":").append(this.port).append(this.path).append("'");
        if (!this.params.isEmpty()) {
            stringBuilder.append(", params=").append(this.params);
        }
        if (Strings.hasLength((String)this.body)) {
            stringBuilder.append(", body=\n").append(this.body);
        }
        return stringBuilder.toString();
    }
}

