/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.client.http;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.test.rest.client.http.HttpRequestBuilder;

public class HttpResponse {
    private static final ESLogger logger = Loggers.getLogger(HttpResponse.class);
    private final HttpUriRequest httpRequest;
    private final int statusCode;
    private final String reasonPhrase;
    private final String body;
    private final Map<String, String> headers = new HashMap<String, String>();

    HttpResponse(HttpUriRequest httpRequest, CloseableHttpResponse httpResponse) {
        this.httpRequest = httpRequest;
        this.statusCode = httpResponse.getStatusLine().getStatusCode();
        this.reasonPhrase = httpResponse.getStatusLine().getReasonPhrase();
        for (Header header : httpResponse.getAllHeaders()) {
            this.headers.put(header.getName(), header.getValue());
        }
        if (httpResponse.getEntity() != null) {
            try {
                this.body = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (Charset)HttpRequestBuilder.DEFAULT_CHARSET);
            }
            catch (IOException e) {
                EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
                throw new RuntimeException(e);
            }
            finally {
                try {
                    httpResponse.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e, new Object[0]);
                }
            }
        }
        this.body = null;
    }

    public boolean isError() {
        return this.statusCode >= 400;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getReasonPhrase() {
        return this.reasonPhrase;
    }

    public String getBody() {
        return this.body;
    }

    public boolean hasBody() {
        return this.body != null;
    }

    public boolean supportsBody() {
        return !"HEAD".equals(this.httpRequest.getMethod());
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.statusCode).append(" ").append(this.reasonPhrase);
        if (this.hasBody()) {
            stringBuilder.append("\n").append(this.body);
        }
        return stringBuilder.toString();
    }
}

