/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.json;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.test.rest.Stash;

public class JsonPath {
    final String json;
    final Map<String, Object> jsonMap;

    public JsonPath(String json) throws IOException {
        this.json = json;
        this.jsonMap = JsonPath.convertToMap(json);
    }

    private static Map<String, Object> convertToMap(String json) throws IOException {
        try (XContentParser parser = JsonXContent.jsonXContent.createParser(json);){
            Map map = parser.mapOrdered();
            return map;
        }
    }

    public Object evaluate(String path) {
        return this.evaluate(path, Stash.EMPTY);
    }

    public Object evaluate(String path, Stash stash) {
        String[] parts = this.parsePath(path);
        Object object = this.jsonMap;
        for (String part : parts) {
            if ((object = this.evaluate(part, object, stash)) != null) continue;
            return null;
        }
        return object;
    }

    private Object evaluate(String key, Object object, Stash stash) {
        if (stash.isStashedValue(key)) {
            key = stash.unstashValue(key).toString();
        }
        if (object instanceof Map) {
            return ((Map)object).get(key);
        }
        if (object instanceof List) {
            List list = (List)object;
            try {
                return list.get(Integer.valueOf(key));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("element was a list, but [" + key + "] was not numeric", e);
            }
            catch (IndexOutOfBoundsException e) {
                throw new IllegalArgumentException("element was a list with " + list.size() + " elements, but [" + key + "] was out of bounds", e);
            }
        }
        throw new IllegalArgumentException("no object found for [" + key + "] within object of class [" + object.getClass() + "]");
    }

    private String[] parsePath(String path) {
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        boolean escape = false;
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == '\\') {
                escape = true;
                continue;
            }
            if (c == '.') {
                if (escape) {
                    escape = false;
                } else {
                    if (current.length() <= 0) continue;
                    list.add(current.toString());
                    current.setLength(0);
                    continue;
                }
            }
            current.append(c);
        }
        if (current.length() > 0) {
            list.add(current.toString());
        }
        return list.toArray(new String[list.size()]);
    }
}

