/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.parser;

import java.io.IOException;
import java.util.HashMap;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.test.rest.parser.RestTestFragmentParser;
import org.elasticsearch.test.rest.parser.RestTestParseException;
import org.elasticsearch.test.rest.parser.RestTestSuiteParseContext;
import org.elasticsearch.test.rest.section.ApiCallSection;
import org.elasticsearch.test.rest.section.DoSection;

public class DoSectionParser
implements RestTestFragmentParser<DoSection> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DoSection parse(RestTestSuiteParseContext parseContext) throws IOException, RestTestParseException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        String currentFieldName = null;
        DoSection doSection = new DoSection();
        ApiCallSection apiCallSection = null;
        HashMap<String, String> headers = new HashMap<String, String>();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if (!"catch".equals(currentFieldName)) continue;
                doSection.setCatch(parser.text());
                continue;
            }
            if (token != XContentParser.Token.START_OBJECT) continue;
            if ("headers".equals(currentFieldName)) {
                String headerName = null;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        headerName = parser.currentName();
                        continue;
                    }
                    if (!token.isValue()) continue;
                    headers.put(headerName, parser.text());
                }
                continue;
            }
            if (currentFieldName == null) continue;
            apiCallSection = new ApiCallSection(currentFieldName);
            String paramName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    paramName = parser.currentName();
                    continue;
                }
                if (token.isValue()) {
                    if ("body".equals(paramName)) {
                        String body = parser.text();
                        XContentType bodyContentType = XContentFactory.xContentType((CharSequence)body);
                        XContentParser bodyParser = XContentFactory.xContent((XContentType)bodyContentType).createParser(body);
                        while (bodyParser.nextToken() != null) {
                            apiCallSection.addBody(bodyParser.mapOrdered());
                        }
                        continue;
                    }
                    apiCallSection.addParam(paramName, parser.text());
                    continue;
                }
                if (token != XContentParser.Token.START_OBJECT || !"body".equals(paramName)) continue;
                apiCallSection.addBody(parser.mapOrdered());
            }
        }
        try {
            if (apiCallSection == null) {
                throw new RestTestParseException("client call section is mandatory within a do section");
            }
            if (!headers.isEmpty()) {
                apiCallSection.addHeaders(headers);
            }
            doSection.setApiCallSection(apiCallSection);
        }
        finally {
            parser.nextToken();
        }
        return doSection;
    }
}

