/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.parser;

import java.io.IOException;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.test.rest.parser.RestTestFragmentParser;
import org.elasticsearch.test.rest.parser.RestTestParseException;
import org.elasticsearch.test.rest.parser.RestTestSuiteParseContext;
import org.elasticsearch.test.rest.section.LengthAssertion;

public class LengthParser
implements RestTestFragmentParser<LengthAssertion> {
    @Override
    public LengthAssertion parse(RestTestSuiteParseContext parseContext) throws IOException, RestTestParseException {
        int value;
        Tuple<String, Object> stringObjectTuple = parseContext.parseTuple();
        assert (stringObjectTuple.v2() != null);
        if (stringObjectTuple.v2() instanceof Number) {
            value = ((Number)stringObjectTuple.v2()).intValue();
        } else {
            try {
                value = Integer.valueOf(stringObjectTuple.v2().toString());
            }
            catch (NumberFormatException e) {
                throw new RestTestParseException("length is not a valid number", e);
            }
        }
        return new LengthAssertion((String)stringObjectTuple.v1(), value);
    }
}

