/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.parser;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.test.rest.parser.DoSectionParser;
import org.elasticsearch.test.rest.parser.GreaterThanEqualToParser;
import org.elasticsearch.test.rest.parser.GreaterThanParser;
import org.elasticsearch.test.rest.parser.IsFalseParser;
import org.elasticsearch.test.rest.parser.IsTrueParser;
import org.elasticsearch.test.rest.parser.LengthParser;
import org.elasticsearch.test.rest.parser.LessThanOrEqualToParser;
import org.elasticsearch.test.rest.parser.LessThanParser;
import org.elasticsearch.test.rest.parser.MatchParser;
import org.elasticsearch.test.rest.parser.RestTestFragmentParser;
import org.elasticsearch.test.rest.parser.RestTestParseException;
import org.elasticsearch.test.rest.parser.RestTestSectionParser;
import org.elasticsearch.test.rest.parser.SetSectionParser;
import org.elasticsearch.test.rest.parser.SetupSectionParser;
import org.elasticsearch.test.rest.parser.SkipSectionParser;
import org.elasticsearch.test.rest.section.DoSection;
import org.elasticsearch.test.rest.section.ExecutableSection;
import org.elasticsearch.test.rest.section.SetupSection;
import org.elasticsearch.test.rest.section.SkipSection;
import org.elasticsearch.test.rest.section.TestSection;

public class RestTestSuiteParseContext {
    private static final SetupSectionParser SETUP_SECTION_PARSER = new SetupSectionParser();
    private static final RestTestSectionParser TEST_SECTION_PARSER = new RestTestSectionParser();
    private static final SkipSectionParser SKIP_SECTION_PARSER = new SkipSectionParser();
    private static final DoSectionParser DO_SECTION_PARSER = new DoSectionParser();
    private static final Map<String, RestTestFragmentParser<? extends ExecutableSection>> EXECUTABLE_SECTIONS_PARSERS = Maps.newHashMap();
    private final String api;
    private final String suiteName;
    private final XContentParser parser;

    public RestTestSuiteParseContext(String api, String suiteName, XContentParser parser) {
        this.api = api;
        this.suiteName = suiteName;
        this.parser = parser;
    }

    public String getApi() {
        return this.api;
    }

    public String getSuiteName() {
        return this.suiteName;
    }

    public XContentParser parser() {
        return this.parser;
    }

    public SetupSection parseSetupSection() throws IOException, RestTestParseException {
        this.advanceToFieldName();
        if ("setup".equals(this.parser.currentName())) {
            this.parser.nextToken();
            SetupSection setupSection = SETUP_SECTION_PARSER.parse(this);
            this.parser.nextToken();
            return setupSection;
        }
        return SetupSection.EMPTY;
    }

    public TestSection parseTestSection() throws IOException, RestTestParseException {
        return TEST_SECTION_PARSER.parse(this);
    }

    public SkipSection parseSkipSection() throws IOException, RestTestParseException {
        this.advanceToFieldName();
        if ("skip".equals(this.parser.currentName())) {
            SkipSection skipSection = SKIP_SECTION_PARSER.parse(this);
            this.parser.nextToken();
            return skipSection;
        }
        return SkipSection.EMPTY;
    }

    public ExecutableSection parseExecutableSection() throws IOException, RestTestParseException {
        this.advanceToFieldName();
        String section = this.parser.currentName();
        RestTestFragmentParser<? extends ExecutableSection> execSectionParser = EXECUTABLE_SECTIONS_PARSERS.get(section);
        if (execSectionParser == null) {
            throw new RestTestParseException("no parser found for executable section [" + section + "]");
        }
        ExecutableSection executableSection = execSectionParser.parse(this);
        this.parser.nextToken();
        return executableSection;
    }

    public DoSection parseDoSection() throws IOException, RestTestParseException {
        return DO_SECTION_PARSER.parse(this);
    }

    public void advanceToFieldName() throws IOException, RestTestParseException {
        XContentParser.Token token = this.parser.currentToken();
        if (token == null) {
            token = this.parser.nextToken();
        }
        if (token == XContentParser.Token.START_ARRAY) {
            token = this.parser.nextToken();
        }
        if (token == XContentParser.Token.START_OBJECT) {
            token = this.parser.nextToken();
        }
        if (token != XContentParser.Token.FIELD_NAME) {
            throw new RestTestParseException("malformed test section: field name expected but found " + token);
        }
    }

    public String parseField() throws IOException, RestTestParseException {
        this.parser.nextToken();
        assert (this.parser.currentToken().isValue());
        String field = this.parser.text();
        this.parser.nextToken();
        return field;
    }

    public Tuple<String, Object> parseTuple() throws IOException, RestTestParseException {
        this.parser.nextToken();
        this.advanceToFieldName();
        Map map = this.parser.map();
        assert (this.parser.currentToken() == XContentParser.Token.END_OBJECT);
        this.parser.nextToken();
        if (map.size() != 1) {
            throw new RestTestParseException("expected key value pair but found " + map.size() + " ");
        }
        Map.Entry entry = map.entrySet().iterator().next();
        return Tuple.tuple(entry.getKey(), entry.getValue());
    }

    static {
        EXECUTABLE_SECTIONS_PARSERS.put("do", DO_SECTION_PARSER);
        EXECUTABLE_SECTIONS_PARSERS.put("set", new SetSectionParser());
        EXECUTABLE_SECTIONS_PARSERS.put("match", new MatchParser());
        EXECUTABLE_SECTIONS_PARSERS.put("is_true", new IsTrueParser());
        EXECUTABLE_SECTIONS_PARSERS.put("is_false", new IsFalseParser());
        EXECUTABLE_SECTIONS_PARSERS.put("gt", new GreaterThanParser());
        EXECUTABLE_SECTIONS_PARSERS.put("gte", new GreaterThanEqualToParser());
        EXECUTABLE_SECTIONS_PARSERS.put("lt", new LessThanParser());
        EXECUTABLE_SECTIONS_PARSERS.put("lte", new LessThanOrEqualToParser());
        EXECUTABLE_SECTIONS_PARSERS.put("length", new LengthParser());
    }
}

