/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.parser;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.yaml.YamlXContent;
import org.elasticsearch.test.rest.parser.RestTestFragmentParser;
import org.elasticsearch.test.rest.parser.RestTestParseException;
import org.elasticsearch.test.rest.parser.RestTestSuiteParseContext;
import org.elasticsearch.test.rest.section.RestTestSuite;
import org.elasticsearch.test.rest.section.TestSection;

public class RestTestSuiteParser
implements RestTestFragmentParser<RestTestSuite> {
    public RestTestSuite parse(String api, Path file) throws IOException, RestTestParseException {
        if (!Files.isRegularFile(file, new LinkOption[0])) {
            throw new IllegalArgumentException(file.toAbsolutePath() + " is not a file");
        }
        String filename = file.getFileName().toString();
        int i = filename.lastIndexOf(46);
        if (i > 0) {
            filename = filename.substring(0, i);
        }
        try (FileChannel channel = FileChannel.open(file, StandardOpenOption.READ);){
            ByteBuffer bb = ByteBuffer.wrap(new byte[1]);
            channel.read(bb, channel.size() - 1L);
            if (bb.get(0) != 10) {
                throw new RestTestParseException("test suite [" + api + "/" + filename + "] doesn't end with line feed (\\n)");
            }
        }
        try (XContentParser parser = YamlXContent.yamlXContent.createParser(Files.newInputStream(file, new OpenOption[0]));){
            RestTestSuiteParseContext testParseContext = new RestTestSuiteParseContext(api, filename, parser);
            RestTestSuite restTestSuite = this.parse(testParseContext);
            return restTestSuite;
        }
    }

    @Override
    public RestTestSuite parse(RestTestSuiteParseContext parseContext) throws IOException, RestTestParseException {
        XContentParser parser = parseContext.parser();
        parser.nextToken();
        assert (parser.currentToken() == XContentParser.Token.START_OBJECT);
        RestTestSuite restTestSuite = new RestTestSuite(parseContext.getApi(), parseContext.getSuiteName());
        restTestSuite.setSetupSection(parseContext.parseSetupSection());
        while (parser.currentToken() != null || parser.nextToken() != null) {
            TestSection testSection = parseContext.parseTestSection();
            if (restTestSuite.addTestSection(testSection)) continue;
            throw new RestTestParseException("duplicate test section [" + testSection.getName() + "] found in [" + restTestSuite.getPath() + "]");
        }
        return restTestSuite;
    }
}

