/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.parser;

import java.io.IOException;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.test.rest.parser.RestTestFragmentParser;
import org.elasticsearch.test.rest.parser.RestTestParseException;
import org.elasticsearch.test.rest.parser.RestTestSuiteParseContext;
import org.elasticsearch.test.rest.section.SetSection;

public class SetSectionParser
implements RestTestFragmentParser<SetSection> {
    @Override
    public SetSection parse(RestTestSuiteParseContext parseContext) throws IOException, RestTestParseException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        String currentFieldName = null;
        SetSection setSection = new SetSection();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (!token.isValue()) continue;
            setSection.addSet(currentFieldName, parser.text());
        }
        parser.nextToken();
        if (setSection.getStash().isEmpty()) {
            throw new RestTestParseException("set section must set at least a value");
        }
        return setSection;
    }
}

