/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.parser;

import java.io.IOException;
import java.util.ArrayList;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.test.rest.parser.RestTestFragmentParser;
import org.elasticsearch.test.rest.parser.RestTestParseException;
import org.elasticsearch.test.rest.parser.RestTestSuiteParseContext;
import org.elasticsearch.test.rest.section.SkipSection;

public class SkipSectionParser
implements RestTestFragmentParser<SkipSection> {
    @Override
    public SkipSection parse(RestTestSuiteParseContext parseContext) throws IOException, RestTestParseException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        String currentFieldName = null;
        String version = null;
        String reason = null;
        ArrayList<String> features = new ArrayList<String>();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if ("version".equals(currentFieldName)) {
                    version = parser.text();
                    continue;
                }
                if ("reason".equals(currentFieldName)) {
                    reason = parser.text();
                    continue;
                }
                if ("features".equals(currentFieldName)) {
                    features.add(parser.text());
                    continue;
                }
                throw new RestTestParseException("field " + currentFieldName + " not supported within skip section");
            }
            if (token != XContentParser.Token.START_ARRAY || !"features".equals(currentFieldName)) continue;
            while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                features.add(parser.text());
            }
        }
        parser.nextToken();
        if (!Strings.hasLength(version) && features.isEmpty()) {
            throw new RestTestParseException("version or features is mandatory within skip section");
        }
        if (Strings.hasLength(version) && !features.isEmpty()) {
            throw new RestTestParseException("version or features are mutually exclusive");
        }
        if (Strings.hasLength(version) && !Strings.hasLength(reason)) {
            throw new RestTestParseException("reason is mandatory within skip version section");
        }
        return new SkipSection(version, features, reason);
    }
}

