/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.section;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ApiCallSection {
    private final String api;
    private final Map<String, String> params = new HashMap<String, String>();
    private final Map<String, String> headers = new HashMap<String, String>();
    private final List<Map<String, Object>> bodies = new ArrayList<Map<String, Object>>();

    public ApiCallSection(String api) {
        this.api = api;
    }

    public String getApi() {
        return this.api;
    }

    public Map<String, String> getParams() {
        return ImmutableMap.copyOf(this.params);
    }

    public void addParam(String key, String value) {
        String existingValue = this.params.get(key);
        if (existingValue != null) {
            value = Joiner.on((String)",").join((Object)existingValue, (Object)value, new Object[0]);
        }
        this.params.put(key, value);
    }

    public void addHeaders(Map<String, String> otherHeaders) {
        this.headers.putAll(otherHeaders);
    }

    public void addHeader(String key, String value) {
        this.headers.put(key, value);
    }

    public Map<String, String> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    public List<Map<String, Object>> getBodies() {
        return Collections.unmodifiableList(this.bodies);
    }

    public void addBody(Map<String, Object> body) {
        this.bodies.add(body);
    }

    public boolean hasBody() {
        return this.bodies.size() > 0;
    }
}

