/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.section;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.test.rest.RestTestExecutionContext;
import org.elasticsearch.test.rest.section.ExecutableSection;

public abstract class Assertion
implements ExecutableSection {
    private final String field;
    private final Object expectedValue;

    protected Assertion(String field, Object expectedValue) {
        this.field = field;
        this.expectedValue = expectedValue;
    }

    public final String getField() {
        return this.field;
    }

    public final Object getExpectedValue() {
        return this.expectedValue;
    }

    protected final Object resolveExpectedValue(RestTestExecutionContext executionContext) throws IOException {
        if (this.expectedValue instanceof Map) {
            Map map = (Map)this.expectedValue;
            return executionContext.stash().unstashMap(map);
        }
        if (executionContext.stash().isStashedValue(this.expectedValue)) {
            return executionContext.stash().unstashValue(this.expectedValue.toString());
        }
        return this.expectedValue;
    }

    protected final Object getActualValue(RestTestExecutionContext executionContext) throws IOException {
        if (executionContext.stash().isStashedValue(this.field)) {
            return executionContext.stash().unstashValue(this.field);
        }
        return executionContext.response(this.field);
    }

    @Override
    public final void execute(RestTestExecutionContext executionContext) throws IOException {
        this.doAssert(this.getActualValue(executionContext), this.resolveExpectedValue(executionContext));
    }

    protected abstract void doAssert(Object var1, Object var2);

    protected Class<?> safeClass(Object o) {
        return o == null ? null : o.getClass();
    }
}

