/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.section;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.test.hamcrest.RegexMatcher;
import org.elasticsearch.test.rest.RestTestExecutionContext;
import org.elasticsearch.test.rest.client.RestException;
import org.elasticsearch.test.rest.client.RestResponse;
import org.elasticsearch.test.rest.section.ApiCallSection;
import org.elasticsearch.test.rest.section.ExecutableSection;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class DoSection
implements ExecutableSection {
    private static final ESLogger logger = Loggers.getLogger(DoSection.class);
    private String catchParam;
    private ApiCallSection apiCallSection;
    private static Map<String, Tuple<String, Matcher<Integer>>> catches = Maps.newHashMap();

    public String getCatch() {
        return this.catchParam;
    }

    public void setCatch(String catchParam) {
        this.catchParam = catchParam;
    }

    public ApiCallSection getApiCallSection() {
        return this.apiCallSection;
    }

    public void setApiCallSection(ApiCallSection apiCallSection) {
        this.apiCallSection = apiCallSection;
    }

    @Override
    public void execute(RestTestExecutionContext executionContext) throws IOException {
        if ("param".equals(this.catchParam)) {
            logger.info("found [catch: param], no request sent", new Object[0]);
            return;
        }
        try {
            RestResponse restResponse = executionContext.callApi(this.apiCallSection.getApi(), this.apiCallSection.getParams(), this.apiCallSection.getBodies(), this.apiCallSection.getHeaders());
            if (Strings.hasLength((String)this.catchParam)) {
                String catchStatusCode;
                if (catches.containsKey(this.catchParam)) {
                    catchStatusCode = (String)catches.get(this.catchParam).v1();
                } else if (this.catchParam.startsWith("/") && this.catchParam.endsWith("/")) {
                    catchStatusCode = "4xx|5xx";
                } else {
                    throw new UnsupportedOperationException("catch value [" + this.catchParam + "] not supported");
                }
                Assert.fail((String)this.formatStatusCodeMessage(restResponse, catchStatusCode));
            }
        }
        catch (RestException e) {
            if (!Strings.hasLength((String)this.catchParam)) {
                Assert.fail((String)this.formatStatusCodeMessage(e.restResponse(), "2xx"));
            }
            if (catches.containsKey(this.catchParam)) {
                this.assertStatusCode(e.restResponse());
            }
            if (this.catchParam.length() > 2 && this.catchParam.startsWith("/") && this.catchParam.endsWith("/")) {
                Assert.assertThat((String)this.formatStatusCodeMessage(e.restResponse(), "4xx|5xx"), (Object)e.statusCode(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(400)));
                Object error = executionContext.response("error");
                Assert.assertThat((String)"error was expected in the response", (Object)error, (Matcher)Matchers.notNullValue());
                String regex = this.catchParam.substring(1, this.catchParam.length() - 1);
                Assert.assertThat((String)"the error message was expected to match the provided regex but didn't", (Object)error.toString(), (Matcher)RegexMatcher.matches(regex));
            }
            throw new UnsupportedOperationException("catch value [" + this.catchParam + "] not supported");
        }
    }

    private void assertStatusCode(RestResponse restResponse) {
        Tuple<String, Matcher<Integer>> stringMatcherTuple = catches.get(this.catchParam);
        Assert.assertThat((String)this.formatStatusCodeMessage(restResponse, (String)stringMatcherTuple.v1()), (Object)restResponse.getStatusCode(), (Matcher)((Matcher)stringMatcherTuple.v2()));
    }

    private String formatStatusCodeMessage(RestResponse restResponse, String expected) {
        return "expected [" + expected + "] status code but api [" + this.apiCallSection.getApi() + "] returned [" + restResponse.getStatusCode() + " " + restResponse.getReasonPhrase() + "] [" + restResponse.getBodyAsString() + "]";
    }

    static {
        catches.put("missing", (Tuple<String, Matcher<Integer>>)Tuple.tuple((Object)"404", (Object)Matchers.equalTo((Object)404)));
        catches.put("conflict", (Tuple<String, Matcher<Integer>>)Tuple.tuple((Object)"409", (Object)Matchers.equalTo((Object)409)));
        catches.put("forbidden", (Tuple<String, Matcher<Integer>>)Tuple.tuple((Object)"403", (Object)Matchers.equalTo((Object)403)));
        catches.put("request_timeout", (Tuple<String, Matcher<Integer>>)Tuple.tuple((Object)"408", (Object)Matchers.equalTo((Object)408)));
        catches.put("unavailable", (Tuple<String, Matcher<Integer>>)Tuple.tuple((Object)"503", (Object)Matchers.equalTo((Object)503)));
        catches.put("request", (Tuple<String, Matcher<Integer>>)Tuple.tuple((Object)"4xx|5xx", (Object)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(400)), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)404)), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)408)), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)409)), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)403)))));
    }
}

