/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.section;

import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.test.rest.section.Assertion;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class GreaterThanAssertion
extends Assertion {
    private static final ESLogger logger = Loggers.getLogger(GreaterThanAssertion.class);

    public GreaterThanAssertion(String field, Object expectedValue) {
        super(field, expectedValue);
    }

    @Override
    protected void doAssert(Object actualValue, Object expectedValue) {
        logger.trace("assert that [{}] is greater than [{}] (field: [{}])", new Object[]{actualValue, expectedValue, this.getField()});
        Assert.assertThat((String)("value of [" + this.getField() + "] is not comparable (got [" + this.safeClass(actualValue) + "])"), (Object)actualValue, (Matcher)Matchers.instanceOf(Comparable.class));
        Assert.assertThat((String)("expected value of [" + this.getField() + "] is not comparable (got [" + expectedValue.getClass() + "])"), (Object)expectedValue, (Matcher)Matchers.instanceOf(Comparable.class));
        try {
            Assert.assertThat((String)this.errorMessage(), (Object)((Comparable)actualValue), (Matcher)Matchers.greaterThan((Comparable)((Comparable)expectedValue)));
        }
        catch (ClassCastException e) {
            Assert.fail((String)("cast error while checking (" + this.errorMessage() + "): " + e));
        }
    }

    private String errorMessage() {
        return "field [" + this.getField() + "] is not greater than [" + this.getExpectedValue() + "]";
    }
}

