/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.section;

import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.test.rest.section.Assertion;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class IsFalseAssertion
extends Assertion {
    private static final ESLogger logger = Loggers.getLogger(IsFalseAssertion.class);

    public IsFalseAssertion(String field) {
        super(field, false);
    }

    @Override
    protected void doAssert(Object actualValue, Object expectedValue) {
        logger.trace("assert that [{}] doesn't have a true value (field: [{}])", new Object[]{actualValue, this.getField()});
        if (actualValue == null) {
            return;
        }
        String actualString = actualValue.toString();
        Assert.assertThat((String)this.errorMessage(), (Object)actualString, (Matcher)Matchers.anyOf((Matcher)Matchers.equalTo((Object)""), (Matcher)Matchers.equalToIgnoringCase((String)Boolean.FALSE.toString()), (Matcher)Matchers.equalTo((Object)"0")));
    }

    private String errorMessage() {
        return "field [" + this.getField() + "] has a true value but it shouldn't";
    }
}

