/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.section;

import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.test.rest.section.Assertion;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class IsTrueAssertion
extends Assertion {
    private static final ESLogger logger = Loggers.getLogger(IsTrueAssertion.class);

    public IsTrueAssertion(String field) {
        super(field, true);
    }

    @Override
    protected void doAssert(Object actualValue, Object expectedValue) {
        logger.trace("assert that [{}] has a true value (field [{}])", new Object[]{actualValue, this.getField()});
        String errorMessage = this.errorMessage();
        Assert.assertThat((String)errorMessage, (Object)actualValue, (Matcher)Matchers.notNullValue());
        String actualString = actualValue.toString();
        Assert.assertThat((String)errorMessage, (Object)actualString, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)"")));
        Assert.assertThat((String)errorMessage, (Object)actualString, (Matcher)Matchers.not((Matcher)Matchers.equalToIgnoringCase((String)Boolean.FALSE.toString())));
        Assert.assertThat((String)errorMessage, (Object)actualString, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)"0")));
    }

    private String errorMessage() {
        return "field [" + this.getField() + "] doesn't have a true value";
    }
}

