/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.section;

import java.util.List;
import java.util.Map;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.test.rest.section.Assertion;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class LengthAssertion
extends Assertion {
    private static final ESLogger logger = Loggers.getLogger(LengthAssertion.class);

    public LengthAssertion(String field, Object expectedValue) {
        super(field, expectedValue);
    }

    @Override
    protected void doAssert(Object actualValue, Object expectedValue) {
        logger.trace("assert that [{}] has length [{}] (field: [{}])", new Object[]{actualValue, expectedValue, this.getField()});
        Assert.assertThat((String)("expected value of [" + this.getField() + "] is not numeric (got [" + expectedValue.getClass() + "]"), (Object)expectedValue, (Matcher)Matchers.instanceOf(Number.class));
        int length = ((Number)expectedValue).intValue();
        if (actualValue instanceof String) {
            Assert.assertThat((String)this.errorMessage(), (Object)((String)actualValue).length(), (Matcher)Matchers.equalTo((Object)length));
        } else if (actualValue instanceof List) {
            Assert.assertThat((String)this.errorMessage(), (Object)((List)actualValue).size(), (Matcher)Matchers.equalTo((Object)length));
        } else if (actualValue instanceof Map) {
            Assert.assertThat((String)this.errorMessage(), (Object)((Map)actualValue).keySet().size(), (Matcher)Matchers.equalTo((Object)length));
        } else {
            throw new UnsupportedOperationException("value is of unsupported type [" + this.safeClass(actualValue) + "]");
        }
    }

    private String errorMessage() {
        return "field [" + this.getField() + "] doesn't have length [" + this.getExpectedValue() + "]";
    }
}

