/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.section;

import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.test.rest.section.Assertion;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class LessThanOrEqualToAssertion
extends Assertion {
    private static final ESLogger logger = Loggers.getLogger(LessThanOrEqualToAssertion.class);

    public LessThanOrEqualToAssertion(String field, Object expectedValue) {
        super(field, expectedValue);
    }

    @Override
    protected void doAssert(Object actualValue, Object expectedValue) {
        logger.trace("assert that [{}] is less than or equal to [{}] (field: [{}])", new Object[]{actualValue, expectedValue, this.getField()});
        Assert.assertThat((String)("value of [" + this.getField() + "] is not comparable (got [" + this.safeClass(actualValue) + "])"), (Object)actualValue, (Matcher)Matchers.instanceOf(Comparable.class));
        Assert.assertThat((String)("expected value of [" + this.getField() + "] is not comparable (got [" + expectedValue.getClass() + "])"), (Object)expectedValue, (Matcher)Matchers.instanceOf(Comparable.class));
        try {
            Assert.assertThat((String)this.errorMessage(), (Object)((Comparable)actualValue), (Matcher)Matchers.lessThanOrEqualTo((Comparable)((Comparable)expectedValue)));
        }
        catch (ClassCastException e) {
            Assert.fail((String)("cast error while checking (" + this.errorMessage() + "): " + e));
        }
    }

    private String errorMessage() {
        return "field [" + this.getField() + "] is not less than or equal to [" + this.getExpectedValue() + "]";
    }
}

