/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.section;

import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.test.hamcrest.RegexMatcher;
import org.elasticsearch.test.rest.section.Assertion;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class MatchAssertion
extends Assertion {
    private static final ESLogger logger = Loggers.getLogger(MatchAssertion.class);

    public MatchAssertion(String field, Object expectedValue) {
        super(field, expectedValue);
    }

    @Override
    protected void doAssert(Object actualValue, Object expectedValue) {
        String expValue;
        if (expectedValue instanceof String && (expValue = ((String)expectedValue).trim()).length() > 2 && expValue.startsWith("/") && expValue.endsWith("/")) {
            Assert.assertThat((String)("field [" + this.getField() + "] was expected to be of type String but is an instanceof [" + this.safeClass(actualValue) + "]"), (Object)actualValue, (Matcher)Matchers.instanceOf(String.class));
            String stringValue = (String)actualValue;
            String regex = expValue.substring(1, expValue.length() - 1);
            logger.trace("assert that [{}] matches [{}]", new Object[]{stringValue, regex});
            Assert.assertThat((String)("field [" + this.getField() + "] was expected to match the provided regex but didn't"), (Object)stringValue, (Matcher)RegexMatcher.matches(regex, 4));
            return;
        }
        Assert.assertThat((String)this.errorMessage(), (Object)actualValue, (Matcher)Matchers.notNullValue());
        logger.trace("assert that [{}] matches [{}] (field [{}])", new Object[]{actualValue, expectedValue, this.getField()});
        if (!actualValue.getClass().equals(this.safeClass(expectedValue)) && actualValue instanceof Number && expectedValue instanceof Number) {
            Assert.assertThat((String)this.errorMessage(), (Object)((Number)actualValue).doubleValue(), (Matcher)Matchers.equalTo((Object)((Number)expectedValue).doubleValue()));
            return;
        }
        Assert.assertThat((String)this.errorMessage(), (Object)actualValue, (Matcher)Matchers.equalTo((Object)expectedValue));
    }

    private String errorMessage() {
        return "field [" + this.getField() + "] doesn't match the expected value";
    }
}

