/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.section;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.Version;
import org.elasticsearch.test.VersionUtils;
import org.elasticsearch.test.rest.support.Features;

public class SkipSection {
    public static final SkipSection EMPTY = new SkipSection();
    private final Version lowerVersion;
    private final Version upperVersion;
    private final List<String> features;
    private final String reason;

    private SkipSection() {
        this.lowerVersion = null;
        this.upperVersion = null;
        this.features = new ArrayList<String>();
        this.reason = null;
    }

    public SkipSection(String versionRange, List<String> features, String reason) {
        assert (features != null);
        assert (versionRange != null && features.isEmpty() || versionRange == null && !features.isEmpty());
        Version[] versions = this.parseVersionRange(versionRange);
        this.lowerVersion = versions[0];
        this.upperVersion = versions[1];
        this.features = features;
        this.reason = reason;
    }

    public Version getLowerVersion() {
        return this.lowerVersion;
    }

    public Version getUpperVersion() {
        return this.upperVersion;
    }

    public List<String> getFeatures() {
        return this.features;
    }

    public String getReason() {
        return this.reason;
    }

    public boolean skip(Version currentVersion) {
        if (this.isEmpty()) {
            return false;
        }
        if (this.isVersionCheck()) {
            return currentVersion.onOrAfter(this.lowerVersion) && currentVersion.onOrBefore(this.upperVersion);
        }
        return !Features.areAllSupported(this.features);
    }

    public boolean isVersionCheck() {
        return this.features.isEmpty();
    }

    public boolean isEmpty() {
        return EMPTY.equals(this);
    }

    private Version[] parseVersionRange(String versionRange) {
        if (versionRange == null) {
            return new Version[]{null, null};
        }
        if (versionRange.trim().equals("all")) {
            return new Version[]{VersionUtils.getFirstVersion(), Version.CURRENT};
        }
        String[] skipVersions = versionRange.split("-");
        if (skipVersions.length > 2) {
            throw new IllegalArgumentException("version range malformed: " + versionRange);
        }
        String lower = skipVersions[0].trim();
        String upper = skipVersions[1].trim();
        return new Version[]{lower.isEmpty() ? VersionUtils.getFirstVersion() : Version.fromString((String)lower), upper.isEmpty() ? Version.CURRENT : Version.fromString((String)upper)};
    }
}

