/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.spec;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.test.rest.client.RestPath;

public class RestApi {
    private final String name;
    private List<String> methods = new ArrayList<String>();
    private List<String> paths = new ArrayList<String>();
    private List<String> pathParts = new ArrayList<String>();
    private List<String> params = new ArrayList<String>();
    private BODY body = BODY.NOT_SUPPORTED;

    RestApi(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getMethods() {
        return this.methods;
    }

    public List<String> getSupportedMethods(Set<String> restParams) {
        if ("index".equals(this.name) || "create".equals(this.name)) {
            ArrayList<String> indexMethods = new ArrayList<String>();
            for (String method : this.methods) {
                if (restParams.contains("id")) {
                    if (!"PUT".equals(method)) continue;
                    indexMethods.add(method);
                    continue;
                }
                if (!"POST".equals(method)) continue;
                indexMethods.add(method);
            }
            return indexMethods;
        }
        return this.methods;
    }

    void addMethod(String method) {
        this.methods.add(method);
    }

    public List<String> getPaths() {
        return this.paths;
    }

    void addPath(String path) {
        this.paths.add(path);
    }

    public List<String> getPathParts() {
        return this.pathParts;
    }

    void addPathPart(String pathPart) {
        this.pathParts.add(pathPart);
    }

    public List<String> getParams() {
        return this.params;
    }

    void addParam(String param) {
        this.params.add(param);
    }

    void setBodyOptional() {
        this.body = BODY.OPTIONAL;
    }

    void setBodyRequired() {
        this.body = BODY.REQUIRED;
    }

    public boolean isBodySupported() {
        return this.body != BODY.NOT_SUPPORTED;
    }

    public boolean isBodyRequired() {
        return this.body == BODY.REQUIRED;
    }

    public RestPath[] getFinalPaths(Map<String, String> pathParams) {
        List<RestPath> matchingRestPaths = this.findMatchingRestPaths(pathParams.keySet());
        if (matchingRestPaths == null || matchingRestPaths.isEmpty()) {
            throw new IllegalArgumentException("unable to find matching rest path for api [" + this.name + "] and path params " + pathParams);
        }
        RestPath[] restPaths = new RestPath[matchingRestPaths.size()];
        for (int i = 0; i < matchingRestPaths.size(); ++i) {
            RestPath restPath = matchingRestPaths.get(i);
            restPaths[i] = restPath.replacePlaceholders(pathParams);
        }
        return restPaths;
    }

    private List<RestPath> findMatchingRestPaths(Set<String> restParams) {
        RestPath[] restPaths;
        ArrayList<RestPath> matchingRestPaths = new ArrayList<RestPath>();
        for (RestPath restPath : restPaths = this.buildRestPaths()) {
            if (!restPath.matches(restParams)) continue;
            matchingRestPaths.add(restPath);
        }
        return matchingRestPaths;
    }

    private RestPath[] buildRestPaths() {
        RestPath[] restPaths = new RestPath[this.paths.size()];
        for (int i = 0; i < restPaths.length; ++i) {
            restPaths[i] = new RestPath(this.paths.get(i));
        }
        return restPaths;
    }

    public static enum BODY {
        NOT_SUPPORTED,
        OPTIONAL,
        REQUIRED;

    }
}

