/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.spec;

import java.io.IOException;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.test.rest.spec.RestApi;

public class RestApiParser {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RestApi parse(XContentParser parser) throws IOException {
        try {
            while (parser.nextToken() != XContentParser.Token.FIELD_NAME) {
            }
            RestApi restApi = new RestApi(parser.currentName());
            int level = -1;
            while (parser.nextToken() != XContentParser.Token.END_OBJECT || level >= 0) {
                if (parser.currentToken() == XContentParser.Token.FIELD_NAME) {
                    if ("methods".equals(parser.currentName())) {
                        parser.nextToken();
                        while (parser.nextToken() == XContentParser.Token.VALUE_STRING) {
                            restApi.addMethod(parser.text());
                        }
                    }
                    if ("url".equals(parser.currentName())) {
                        String currentFieldName = "url";
                        int innerLevel = -1;
                        while (parser.nextToken() != XContentParser.Token.END_OBJECT || innerLevel >= 0) {
                            if (parser.currentToken() == XContentParser.Token.FIELD_NAME) {
                                currentFieldName = parser.currentName();
                            }
                            if (parser.currentToken() == XContentParser.Token.START_ARRAY && "paths".equals(currentFieldName)) {
                                while (parser.nextToken() == XContentParser.Token.VALUE_STRING) {
                                    restApi.addPath(parser.text());
                                }
                            }
                            if (parser.currentToken() == XContentParser.Token.START_OBJECT && "parts".equals(currentFieldName)) {
                                while (parser.nextToken() == XContentParser.Token.FIELD_NAME) {
                                    restApi.addPathPart(parser.currentName());
                                    parser.nextToken();
                                    if (parser.currentToken() != XContentParser.Token.START_OBJECT) {
                                        throw new IOException("Expected parts field in rest api definition to contain an object");
                                    }
                                    parser.skipChildren();
                                }
                            }
                            if (parser.currentToken() == XContentParser.Token.START_OBJECT && "params".equals(currentFieldName)) {
                                while (parser.nextToken() == XContentParser.Token.FIELD_NAME) {
                                    restApi.addParam(parser.currentName());
                                    parser.nextToken();
                                    if (parser.currentToken() != XContentParser.Token.START_OBJECT) {
                                        throw new IOException("Expected params field in rest api definition to contain an object");
                                    }
                                    parser.skipChildren();
                                }
                            }
                            if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                                ++innerLevel;
                            }
                            if (parser.currentToken() != XContentParser.Token.END_OBJECT) continue;
                            --innerLevel;
                        }
                    }
                    if ("body".equals(parser.currentName())) {
                        parser.nextToken();
                        if (parser.currentToken() != XContentParser.Token.VALUE_NULL) {
                            boolean requiredFound = false;
                            while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                                if (parser.currentToken() != XContentParser.Token.FIELD_NAME || !"required".equals(parser.currentName())) continue;
                                requiredFound = true;
                                parser.nextToken();
                                if (parser.booleanValue()) {
                                    restApi.setBodyRequired();
                                    continue;
                                }
                                restApi.setBodyOptional();
                            }
                            if (!requiredFound) {
                                restApi.setBodyOptional();
                            }
                        }
                    }
                }
                if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                    ++level;
                }
                if (parser.currentToken() != XContentParser.Token.END_OBJECT) continue;
                --level;
            }
            parser.nextToken();
            assert (parser.currentToken() == XContentParser.Token.END_OBJECT) : "Expected [END_OBJECT] but was [" + parser.currentToken() + "]";
            parser.nextToken();
            RestApi restApi2 = restApi;
            return restApi2;
        }
        finally {
            parser.close();
        }
    }
}

