/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.spec;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.test.rest.spec.RestApi;
import org.elasticsearch.test.rest.spec.RestApiParser;
import org.elasticsearch.test.rest.support.FileUtils;

public class RestSpec {
    Map<String, RestApi> restApiMap = Maps.newHashMap();

    private RestSpec() {
    }

    void addApi(RestApi restApi) {
        this.restApiMap.put(restApi.getName(), restApi);
    }

    public RestApi getApi(String api) {
        return this.restApiMap.get(api);
    }

    public Collection<RestApi> getApis() {
        return this.restApiMap.values();
    }

    public static RestSpec parseFrom(FileSystem fileSystem, String optionalPathPrefix, String ... paths) throws IOException {
        RestSpec restSpec = new RestSpec();
        for (String path : paths) {
            for (Path jsonFile : FileUtils.findJsonSpec(fileSystem, optionalPathPrefix, path)) {
                try {
                    InputStream stream = Files.newInputStream(jsonFile, new OpenOption[0]);
                    Throwable throwable = null;
                    try {
                        XContentParser parser = JsonXContent.jsonXContent.createParser(stream);
                        RestApi restApi = new RestApiParser().parse(parser);
                        restSpec.addApi(restApi);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (stream == null) continue;
                        if (throwable != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        stream.close();
                    }
                }
                catch (Throwable ex) {
                    throw new IOException("Can't parse rest spec file: [" + jsonFile + "]", ex);
                }
            }
        }
        return restSpec;
    }
}

