/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.search.aggregations.bucket;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.elasticsearch.Version;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.significant.SignificantTerms;
import org.elasticsearch.search.aggregations.bucket.significant.SignificantTermsBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.StringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsBuilder;
import org.elasticsearch.test.ESIntegTestCase;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.hamcrest.ElasticsearchAssertions;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class SharedSignificantTermsTestMethods {
    public static final String INDEX_NAME = "testidx";
    public static final String DOC_TYPE = "doc";
    public static final String TEXT_FIELD = "text";
    public static final String CLASS_FIELD = "class";

    public static void aggregateAndCheckFromSeveralShards(ESIntegTestCase testCase, Version esVersion) throws ExecutionException, InterruptedException {
        String type;
        String string = type = ESTestCase.randomBoolean() ? "string" : "long";
        if (esVersion.before(Version.V_2_0_2) || esVersion.equals((Object)Version.V_2_1_0)) {
            type = "string";
        }
        String settings = "{\"index.number_of_shards\": 5, \"index.number_of_replicas\": 0}";
        SharedSignificantTermsTestMethods.index01Docs(type, settings, testCase);
        testCase.ensureGreen(new String[0]);
        testCase.logClusterState();
        SharedSignificantTermsTestMethods.checkSignificantTermsAggregationCorrect(testCase);
    }

    private static void checkSignificantTermsAggregationCorrect(ESIntegTestCase testCase) {
        SearchResponse response = (SearchResponse)testCase.client().prepareSearch(new String[]{INDEX_NAME}).setTypes(new String[]{DOC_TYPE}).addAggregation((AbstractAggregationBuilder)((TermsBuilder)new TermsBuilder(CLASS_FIELD).field(CLASS_FIELD)).subAggregation((AbstractAggregationBuilder)new SignificantTermsBuilder("sig_terms").field(TEXT_FIELD))).execute().actionGet();
        ElasticsearchAssertions.assertSearchResponse(response);
        StringTerms classes = (StringTerms)response.getAggregations().get(CLASS_FIELD);
        Assert.assertThat((Object)classes.getBuckets().size(), (Matcher)Matchers.equalTo((Object)2));
        for (Terms.Bucket classBucket : classes.getBuckets()) {
            Map aggs = classBucket.getAggregations().asMap();
            Assert.assertTrue((boolean)aggs.containsKey("sig_terms"));
            SignificantTerms agg = (SignificantTerms)aggs.get("sig_terms");
            Assert.assertThat((Object)agg.getBuckets().size(), (Matcher)Matchers.equalTo((Object)1));
            SignificantTerms.Bucket sigBucket = (SignificantTerms.Bucket)agg.iterator().next();
            String term = sigBucket.getKeyAsString();
            String classTerm = classBucket.getKeyAsString();
            Assert.assertTrue((boolean)term.equals(classTerm));
        }
    }

    public static void index01Docs(String type, String settings, ESIntegTestCase testCase) throws ExecutionException, InterruptedException {
        String mappings = "{\"doc\": {\"properties\":{\"text\": {\"type\":\"" + type + "\"}}}}";
        ElasticsearchAssertions.assertAcked(testCase.prepareCreate(INDEX_NAME).setSettings(settings).addMapping(DOC_TYPE, mappings));
        String[] gb = new String[]{"0", "1"};
        ArrayList<IndexRequestBuilder> indexRequestBuilderList = new ArrayList<IndexRequestBuilder>();
        indexRequestBuilderList.add(ESIntegTestCase.client().prepareIndex(INDEX_NAME, DOC_TYPE, "1").setSource(TEXT_FIELD, (Object)"1", CLASS_FIELD, (Object)"1"));
        indexRequestBuilderList.add(ESIntegTestCase.client().prepareIndex(INDEX_NAME, DOC_TYPE, "2").setSource(TEXT_FIELD, (Object)"1", CLASS_FIELD, (Object)"1"));
        indexRequestBuilderList.add(ESIntegTestCase.client().prepareIndex(INDEX_NAME, DOC_TYPE, "3").setSource(TEXT_FIELD, (Object)"0", CLASS_FIELD, (Object)"0"));
        indexRequestBuilderList.add(ESIntegTestCase.client().prepareIndex(INDEX_NAME, DOC_TYPE, "4").setSource(TEXT_FIELD, (Object)"0", CLASS_FIELD, (Object)"0"));
        indexRequestBuilderList.add(ESIntegTestCase.client().prepareIndex(INDEX_NAME, DOC_TYPE, "5").setSource(TEXT_FIELD, (Object)gb, CLASS_FIELD, (Object)"1"));
        indexRequestBuilderList.add(ESIntegTestCase.client().prepareIndex(INDEX_NAME, DOC_TYPE, "6").setSource(TEXT_FIELD, (Object)gb, CLASS_FIELD, (Object)"0"));
        indexRequestBuilderList.add(ESIntegTestCase.client().prepareIndex(INDEX_NAME, DOC_TYPE, "7").setSource(TEXT_FIELD, (Object)"0", CLASS_FIELD, (Object)"0"));
        testCase.indexRandom(true, false, indexRequestBuilderList);
    }
}

