/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.store;

import com.carrotsearch.randomizedtesting.SeedUtils;
import com.carrotsearch.randomizedtesting.generators.RandomPicks;
import com.google.common.base.Charsets;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Random;
import org.apache.lucene.index.CheckIndex;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.BaseDirectoryWrapper;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.MockDirectoryWrapper;
import org.apache.lucene.store.StoreRateLimiting;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.TestRuleMarkFailure;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.settings.IndexSettingsService;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardPath;
import org.elasticsearch.index.store.FsDirectoryService;
import org.elasticsearch.index.store.IndexStore;
import org.elasticsearch.index.store.IndexStoreModule;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.indices.IndicesLifecycle;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.test.ESTestCase;
import org.junit.Assert;

public class MockFSDirectoryService
extends FsDirectoryService {
    public static final String CHECK_INDEX_ON_CLOSE = "index.store.mock.check_index_on_close";
    public static final String RANDOM_IO_EXCEPTION_RATE_ON_OPEN = "index.store.mock.random.io_exception_rate_on_open";
    public static final String RANDOM_PREVENT_DOUBLE_WRITE = "index.store.mock.random.prevent_double_write";
    public static final String RANDOM_NO_DELETE_OPEN_FILE = "index.store.mock.random.no_delete_open_file";
    public static final String CRASH_INDEX = "index.store.mock.random.crash_index";
    private static final EnumSet<IndexShardState> validCheckIndexStates = EnumSet.of(IndexShardState.STARTED, IndexShardState.RELOCATED, IndexShardState.POST_RECOVERY);
    private final FsDirectoryService delegateService;
    private final boolean checkIndexOnClose;
    private final Random random;
    private final double randomIOExceptionRate;
    private final double randomIOExceptionRateOnOpen;
    private final MockDirectoryWrapper.Throttling throttle;
    private final boolean preventDoubleWrite;
    private final boolean noDeleteOpenFile;
    private final boolean crashIndex;
    public static final String RANDOM_IO_EXCEPTION_RATE = "index.store.mock.random.io_exception_rate";

    @Inject
    public MockFSDirectoryService(IndexSettingsService indexSettingsService, IndexStore indexStore, final IndicesService service, ShardPath path) {
        super(indexSettingsService.getSettings(), indexStore, path);
        long seed = this.indexSettings.getAsLong("index.tests.seed", Long.valueOf(0L));
        this.random = new Random(seed);
        this.checkIndexOnClose = this.indexSettings.getAsBoolean(CHECK_INDEX_ON_CLOSE, Boolean.valueOf(true));
        this.randomIOExceptionRate = this.indexSettings.getAsDouble(RANDOM_IO_EXCEPTION_RATE, Double.valueOf(0.0));
        this.randomIOExceptionRateOnOpen = this.indexSettings.getAsDouble(RANDOM_IO_EXCEPTION_RATE_ON_OPEN, Double.valueOf(0.0));
        this.preventDoubleWrite = this.indexSettings.getAsBoolean(RANDOM_PREVENT_DOUBLE_WRITE, Boolean.valueOf(true));
        this.noDeleteOpenFile = this.indexSettings.getAsBoolean(RANDOM_NO_DELETE_OPEN_FILE, Boolean.valueOf(this.random.nextBoolean()));
        this.random.nextInt(this.shardId.getId() + 1);
        this.throttle = MockDirectoryWrapper.Throttling.NEVER;
        this.crashIndex = this.indexSettings.getAsBoolean(CRASH_INDEX, Boolean.valueOf(true));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Using MockDirWrapper with seed [{}] throttle: [{}] crashIndex: [{}]", new Object[]{SeedUtils.formatSeed((long)seed), this.throttle, this.crashIndex});
        }
        this.delegateService = this.randomDirectorService(indexStore, path);
        if (this.checkIndexOnClose) {
            IndicesLifecycle.Listener listener = new IndicesLifecycle.Listener(){
                boolean canRun = false;

                public void beforeIndexShardClosed(ShardId sid, @Nullable IndexShard indexShard, Settings indexSettings) {
                    if (indexShard != null && MockFSDirectoryService.this.shardId.equals((Object)sid) && validCheckIndexStates.contains(indexShard.state()) && !IndexMetaData.isOnSharedFilesystem((Settings)indexSettings)) {
                        this.canRun = true;
                    }
                }

                public void afterIndexShardClosed(ShardId sid, @Nullable IndexShard indexShard, Settings indexSettings) {
                    if (MockFSDirectoryService.this.shardId.equals((Object)sid) && indexShard != null && this.canRun) {
                        assert (indexShard.state() == IndexShardState.CLOSED) : "Current state must be closed";
                        MockFSDirectoryService.this.checkIndex(indexShard.store(), sid);
                    }
                    service.indicesLifecycle().removeListener((IndicesLifecycle.Listener)this);
                }
            };
            service.indicesLifecycle().addListener(listener);
        }
    }

    public Directory newDirectory() throws IOException {
        return this.wrap(this.delegateService.newDirectory());
    }

    protected synchronized Directory newFSDirectory(Path location, LockFactory lockFactory) throws IOException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkIndex(Store store, ShardId shardId) {
        if (store.tryIncRef()) {
            this.logger.info("start check index", new Object[0]);
            try {
                Directory dir = store.directory();
                if (!Lucene.indexExists((Directory)dir)) {
                    return;
                }
                if (IndexWriter.isLocked((Directory)dir)) {
                    ESTestCase.checkIndexFailed = true;
                    throw new IllegalStateException("IndexWriter is still open on shard " + shardId);
                }
                try (CheckIndex checkIndex = new CheckIndex(dir);){
                    BytesStreamOutput os = new BytesStreamOutput();
                    PrintStream out = new PrintStream((OutputStream)os, false, Charsets.UTF_8.name());
                    checkIndex.setInfoStream(out);
                    out.flush();
                    CheckIndex.Status status = checkIndex.checkIndex();
                    if (!status.clean) {
                        ESTestCase.checkIndexFailed = true;
                        this.logger.warn("check index [failure] index files={}\n{}", new Object[]{Arrays.toString(dir.listAll()), new String(os.bytes().toBytes(), Charsets.UTF_8)});
                        throw new IOException("index check failure");
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("check index [success]\n{}", new Object[]{new String(os.bytes().toBytes(), Charsets.UTF_8)});
                    }
                }
            }
            catch (Exception e) {
                this.logger.warn("failed to check index", (Throwable)e, new Object[0]);
            }
            finally {
                this.logger.info("end check index", new Object[0]);
                store.decRef();
            }
        }
    }

    public void onPause(long nanos) {
        this.delegateService.onPause(nanos);
    }

    public StoreRateLimiting rateLimiting() {
        return this.delegateService.rateLimiting();
    }

    public long throttleTimeInNanos() {
        return this.delegateService.throttleTimeInNanos();
    }

    private Directory wrap(Directory dir) {
        ElasticsearchMockDirectoryWrapper w = new ElasticsearchMockDirectoryWrapper(this.random, dir, this.crashIndex);
        w.setRandomIOExceptionRate(this.randomIOExceptionRate);
        w.setRandomIOExceptionRateOnOpen(this.randomIOExceptionRateOnOpen);
        w.setThrottling(this.throttle);
        w.setCheckIndexOnClose(false);
        w.setPreventDoubleWrite(this.preventDoubleWrite);
        w.setEnableVirusScanner(false);
        w.setNoDeleteOpenFile(this.noDeleteOpenFile);
        w.setUseSlowOpenClosers(false);
        LuceneTestCase.closeAfterSuite((Closeable)new CloseableDirectory((BaseDirectoryWrapper)w));
        return w;
    }

    private FsDirectoryService randomDirectorService(IndexStore indexStore, ShardPath path) {
        Settings.Builder builder = Settings.settingsBuilder();
        builder.put(this.indexSettings);
        builder.put("index.store.type", ((IndexStoreModule.Type)RandomPicks.randomFrom((Random)this.random, (Object[])IndexStoreModule.Type.values())).getSettingsKey());
        return new FsDirectoryService(builder.build(), indexStore, path);
    }

    final class CloseableDirectory
    implements Closeable {
        private final BaseDirectoryWrapper dir;
        private final TestRuleMarkFailure failureMarker;

        public CloseableDirectory(BaseDirectoryWrapper dir) {
            this.dir = dir;
            this.failureMarker = ESTestCase.getSuiteFailureMarker();
        }

        @Override
        public void close() {
            if (this.failureMarker.wasSuccessful() && this.dir.isOpen()) {
                Assert.fail((String)("Directory not closed: " + this.dir));
            }
        }
    }

    public static final class ElasticsearchMockDirectoryWrapper
    extends MockDirectoryWrapper {
        private final boolean crash;

        public ElasticsearchMockDirectoryWrapper(Random random, Directory delegate, boolean crash) {
            super(random, delegate);
            this.crash = crash;
        }

        public synchronized void crash() throws IOException {
            if (this.crash) {
                super.crash();
            }
        }
    }
}

