/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.store;

import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.settings.IndexSettingsService;
import org.elasticsearch.index.store.DirectoryService;
import org.elasticsearch.index.store.IndexStore;
import org.elasticsearch.index.store.IndexStoreModule;
import org.elasticsearch.indices.store.IndicesStore;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.test.store.MockFSDirectoryService;

public class MockFSIndexStore
extends IndexStore {
    @Inject
    public MockFSIndexStore(Index index, IndexSettingsService indexSettingsService, IndicesStore indicesStore) {
        super(index, indexSettingsService, indicesStore);
    }

    public Class<? extends DirectoryService> shardDirectory() {
        return MockFSDirectoryService.class;
    }

    public static class TestPlugin
    extends Plugin {
        public String name() {
            return "mock-index-store";
        }

        public String description() {
            return "a mock index store for testing";
        }

        public void onModule(IndexStoreModule indexStoreModule) {
            indexStoreModule.addIndexStore("mock", MockFSIndexStore.class);
        }

        public Settings additionalSettings() {
            return Settings.builder().put("index.store.type", "mock").build();
        }
    }
}

