/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.tasks;

import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskManager;
import org.elasticsearch.test.tasks.MockTaskManagerListener;
import org.elasticsearch.transport.TransportRequest;

public class MockTaskManager
extends TaskManager {
    public static final String USE_MOCK_TASK_MANAGER = "tests.mock.taskmanager.enabled";
    private final Collection<MockTaskManagerListener> listeners = new CopyOnWriteArrayList<MockTaskManagerListener>();

    public MockTaskManager(Settings settings) {
        super(settings);
    }

    public Task register(String type, String action, TransportRequest request) {
        Task task = super.register(type, action, request);
        if (task != null) {
            for (MockTaskManagerListener listener : this.listeners) {
                try {
                    listener.onTaskRegistered(task);
                }
                catch (Throwable t) {
                    this.logger.warn("failed to notify task manager listener about unregistering the task with id {}", t, new Object[]{task.getId()});
                }
            }
        }
        return task;
    }

    public Task unregister(Task task) {
        Task removedTask = super.unregister(task);
        if (removedTask != null) {
            for (MockTaskManagerListener listener : this.listeners) {
                try {
                    listener.onTaskUnregistered(task);
                }
                catch (Throwable t) {
                    this.logger.warn("failed to notify task manager listener about unregistering the task with id {}", t, new Object[]{task.getId()});
                }
            }
        } else {
            this.logger.warn("trying to remove the same with id {} twice", new Object[]{task.getId()});
        }
        return removedTask;
    }

    public void addListener(MockTaskManagerListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(MockTaskManagerListener listener) {
        this.listeners.remove(listener);
    }
}

